import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';
import wait from 'ember-test-helpers/wait';
import Service from 'ember-service';
import { getBitsString } from 'web-client/tests/helpers/bits-string';

moduleForComponent('bits/animated-emote-landing', 'Integration | Component | bits/animated emote landing', {
  beforeEach() {
    this.owner.register('service:bits-room', Service.extend({
      selectedAnimatedEmotePrefix: '',
      isCheerMessage: false,
      channelDisplayName: 'gachi'
    }));
  }
});

test('emotes intro', function (assert) {
  assert.expect(4);

  this.clickedShowTutorial = false;
  this.isShowingEmoteTiers = false;
  this.isSpotlighting = false;

  this.render(hbs`
    {{bits/animated-emote-landing
        clickedShowTutorial=clickedShowTutorial
        isShowingEmoteTiers=isShowingEmoteTiers
        isSpotlighting=isSpotlighting}}
    `);

  return wait().then(() => {
    assert.elementCount(this.$('button.bits-card__close'), 1, 'close button');
    assert.elementCount(this.$('button.bits-card__back'), 0, 'no back button');
    assert.elementCount(this.$('.js-bits-emotes-intro'), 1, 'emotes intro component');
    assert.elementCount(this.$('.js-bits-animated-emote-selector'), 1, 'emotes selector component');
  });
});

test('cheering tutorial', function (assert) {
  assert.expect(3);

  this.render(hbs`
    {{bits/animated-emote-landing
        clickedShowTutorial=true}}
    `);

  return wait().then(() => {
    assert.elementCount(this.$('button.bits-card__close'), 1, 'close button');
    assert.elementCount(this.$('button.bits-card__back'), 1, 'back button');
    assert.elementText(this.$('button.bits-card__back'), getBitsString('button_back'), 'back button text');
  });
});

test('spotlighting an emote', function (assert) {
  assert.expect(4);

  this.render(hbs`
    {{bits/animated-emote-landing
        isSpotlighting=true}}
    `);

  return wait().then(() => {
    assert.elementCount(this.$('button.bits-card__close'), 1, 'close button');
    assert.elementCount(this.$('button.bits-card__back'), 0, 'no back button');
    assert.elementCount(this.$('.js-bits-cheermote-spotlight'), 1, 'spotlight component');
    assert.elementCount(this.$('.js-bits-animated-emote-selector'), 1, 'emotes selector component');
  });
});

test('emote tiers intro', function (assert) {
  assert.expect(5);

  this.render(hbs`
    {{bits/animated-emote-landing
        isShowingEmoteTiers=true}}
    `);

  return wait().then(() => {
    assert.elementCount(this.$('button.bits-card__close'), 1, 'close button');
    assert.elementCount(this.$('button.bits-card__back'), 1, 'back to all emotes button');
    assert.elementCount(this.$('.js-bits-emote-tiers-intro'), 1, 'emote tiers intro component');
    assert.elementCount(this.$('.js-bits-animated-emote-tiers'), 1, 'emotes tiers selector component');
    assert.elementText(this.$('button.bits-card__back'), getBitsString('button_all_emotes'), 'back button text');
  });
});

test('has cheer message', function (assert) {
  assert.expect(14);

  this.owner.lookup('service:bits-room').set('isCheerMessage', true);
  this.isShowingEmoteTiers = false;
  this.isSpotlighting = false;

  this.render(hbs`
    {{bits/animated-emote-landing
        isShowingEmoteTiers=isShowingEmoteTiers
        isSpotlighting=isSpotlighting}}
    `);

  return wait().then(() => {
    assert.elementCount(this.$('button.bits-card__back'), 0, 'no back button');
    assert.elementCount(this.$('button.bits-card__close'), 0, 'no close button');
    assert.elementCount(this.$('.js-bits-cheermote-spotlight'), 1, 'spotlight component');
    assert.elementCount(this.$('.js-bits-animated-emote-selector'), 1, 'emotes selector component');

    // go into emote tiers while cheer message is on
    this.set('isShowingEmoteTiers', true);

    return wait();
  }).then(() => {
    assert.elementCount(this.$('button.bits-card__close'), 0, 'no close button');
    assert.elementCount(this.$('button.bits-card__back'), 1, 'back to emotes button');
    assert.elementText(this.$('button.bits-card__back'), getBitsString('button_all_emotes'), 'back button text');
    assert.elementCount(this.$('.js-bits-cheermote-spotlight'), 1, 'spotlight component');
    assert.elementCount(this.$('.js-bits-animated-emote-tiers'), 1, 'emotes tiers selector component');

    // spotlight a cheermote
    this.set('isSpotlighting', true);

    return wait();
  }).then(() => {
    assert.elementCount(this.$('button.bits-card__close'), 0, 'no close button');
    assert.elementCount(this.$('button.bits-card__back'), 1, 'back to emotes button');
    assert.elementText(this.$('button.bits-card__back'), getBitsString('button_all_emotes'), 'back button text');
    assert.elementCount(this.$('.js-bits-cheermote-spotlight'), 1, 'spotlight component');
    assert.elementCount(this.$('.js-bits-animated-emote-tiers'), 1, 'emotes tiers selector component');
  });
});
