import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';
import wait from 'ember-test-helpers/wait';

moduleForComponent('bits/animated-emote-selector', 'Integration | Component | bits/animated emote selector', {
  beforeEach() {
    this.adjustBitsEmotes = (prefixes) => {
      this.owner.lookup('service:bits-emotes').set('prefixes', prefixes);

      let emoteConfig = this.owner.lookup('service:bits-emotes').get('emoteConfig');
      let emoteImageMap = this.owner.lookup('service:bits-emotes').get('emoteImageMap');
      let newEmoteConfig = {};
      let newEmoteImageMap = {};

      // filter emote configs using provided prefixes
      prefixes.forEach((prefix) => {
        prefix = prefix.toLowerCase();
        newEmoteConfig[prefix] = emoteConfig[prefix];
        newEmoteImageMap[prefix] = emoteImageMap[prefix];
      });

      this.owner.lookup('service:bits-emotes').set('emoteConfig', newEmoteConfig);
      this.owner.lookup('service:bits-emotes').set('emoteImageMap', newEmoteImageMap);
    };
  }
});

test('it renders', function (assert) {
  let prefixes = ['Cheer', 'Kappa', 'Kreygasm'];

  this.render(hbs`{{bits/animated-emote-selector}}`);

  return wait().then(() => {
    this.adjustBitsEmotes(prefixes);
    return wait();
  }).then(() => {
    assert.elementCount(this.$('ul.js-bits-animated-emote-selector'), 1, 'list of emotes');
    assert.elementCount(this.$('li .js-bits-interactive-cheermote'), prefixes.length, 'correct number of prefixes');
  });
});

test('passthrough actions', function (assert) {
  assert.expect(3);

  let actions = [ 'mouseEnterEmote', 'mouseLeaveEmote', 'clickEmote' ];
  actions.forEach((action) => {
    this.on(action, function () {
      assert.ok(true, `${action} action triggered`);
    });
  });

  this.render(hbs`
    {{bits/animated-emote-selector
        mouseEnterEmote=(action 'mouseEnterEmote')
        mouseLeaveEmote=(action 'mouseLeaveEmote')
        clickEmote=(action 'clickEmote')}}
    `);

  return wait().then(() => {
    let $firstCheermote = this.$('li .js-bits-interactive-cheermote').eq(0);

    $firstCheermote.trigger('mouseover');
    $firstCheermote.trigger('mouseleave');
    $firstCheermote.trigger('click');
  });
});

test('filtered and sorted emotes', function (assert) {
  let prefixes = ['Muxy', 'SwiftRage', 'Cheer', 'Kappa', 'Kreygasm', 'Streamlabs'];

  // 'Muxy' and 'Streamlabs' shouldn't show up, and should be aphabetically sorted with 'Cheer' in front
  let discoverablePrefixes = ['Cheer', 'Kappa', 'Kreygasm', 'SwiftRage'];

  // Kappa and SwiftRage's static assets are rendered using tier 1 (others use 100)
  let discoverablePrefixTiers = [100, 1, 100, 1];

  assert.expect(5);

  this.render(hbs`{{bits/animated-emote-selector}}`);

  return wait().then(() => {
    this.adjustBitsEmotes(prefixes);
    return wait();
  }).then(() => {
    let $cheermotes = this.$('li .js-bits-interactive-cheermote');

    assert.elementCount($cheermotes, 4, 'The number of discoverable prefixes should be filtered down to 4');

    discoverablePrefixes.forEach((value, idx) => {
      assert.equal(`${value}${discoverablePrefixTiers[idx]}`, $cheermotes.eq(idx).find('img').data('test-selector'), `${value} prefix is sorted correctly`);
    });
  });
});
