import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';
import Service from 'ember-service';
import wait from 'ember-test-helpers/wait';

moduleForComponent('bits/animated-emote-tiers', 'Integration | Component | bits/animated emote tiers', {
  beforeEach() {
    this.owner.register('service:bits-room', Service.extend({
      selectedAnimatedEmotePrefix: 'gachi',
      selectedAnimatedEmote: {
        tiers: [
          { id: '1' },
          { id: '100' }
        ]
      }
    }));
  }
});

test('it renders', function (assert) {
  assert.expect(2);

  this.render(hbs`{{bits/animated-emote-tiers}}`);

  return wait().then(() => {
    assert.elementCount(this.$('ul.js-bits-animated-emote-tiers'), 1, 'list of emote tiers');
    assert.elementCount(this.$('li .js-bits-interactive-cheermote'), 2, 'correct number of tiers');
  });
});

test('passthrough actions', function (assert) {
  assert.expect(3);

  let actions = [ 'mouseEnterEmote', 'mouseLeaveEmote', 'clickEmote' ];
  actions.forEach((action) => {
    this.on(action, function () {
      assert.ok(true, `${action} action triggered`);
    });
  });

  this.render(hbs`
    {{bits/animated-emote-tiers
        mouseEnterEmote=(action 'mouseEnterEmote')
        mouseLeaveEmote=(action 'mouseLeaveEmote')
        clickEmote=(action 'clickEmote')}}
    `);

  return wait().then(() => {
    let $firstCheermote = this.$('li .js-bits-interactive-cheermote').eq(0);

    $firstCheermote.trigger('mouseover');
    $firstCheermote.trigger('mouseleave');
    $firstCheermote.trigger('click');
  });
});
