import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';
import { ASYNC_ERRORS } from 'web-client/helpers/bits-string';
import Service from 'ember-service';
import wait from 'ember-test-helpers/wait';

moduleForComponent('bits/async-error', 'Integration | Component | bits/async-error', {
  beforeEach() {
    this.defaultTemplate = hbs`{{bits/async-error}}`;
  }
});

test('Looks up error message and displays', function (assert) {
  assert.expect(1);

  let status = 'insufficient_balance';
  let fallback = 'not what you want';

  let mockBitsRoomService = Service.extend({
    bitsAsyncErrorStatus: 'insufficient_balance',
    bitsAsyncErrorMessage: 'not what you want'
  });
  this.owner.register('service:bits-room', mockBitsRoomService);
  this.render(this.defaultTemplate);

  return wait().then(() => {
    assert.equal($('.bits-hint--error').text().trim(), ASYNC_ERRORS[status] || fallback);
  });
});

test('Fall back to provided error message', function (assert) {
  assert.expect(1);

  this.set('status', 'novel_status');
  this.set('fallback', 'Have no fear, your Bits inventory is safe! The ability to Cheer will return shortly.');
  this.render(this.defaultTemplate);

  return wait().then(() => {
    assert.equal($('.bits-hint--error').text().trim(), this.get('fallback'));
  });
});

test('Can close by clicking', function (assert) {
  assert.expect(1);

  let mockBitsRoomService = Service.extend({
    dismissTooltip() {
      assert.ok(true);
    }
  });
  this.owner.register('service:bits-room', mockBitsRoomService);
  this.render(this.defaultTemplate);

  return wait().then(() => {
    this.$('.bits-card__contain').click();
  });
});
