import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';
import wait from 'ember-test-helpers/wait';

moduleForComponent('bits/available-emotes', 'Integration | Component | bits/available emotes');

test('show 1 emote @ 1', function (assert) {
  assert.expect(1);

  this.render(hbs`
    {{bits/available-emotes amount=1}}
  `);

  return wait().then(() => {
    assert.equal(this.$().find('.bits-emotes__image').length, 1, '1 emote @ 1');
  });
});

test('show 2 emotes @ 100', function (assert) {
  assert.expect(1);

  this.render(hbs`
    {{bits/available-emotes amount=100}}
  `);

  return wait().then(() => {
    assert.equal(this.$().find('.bits-emotes__image').length, 2, '2 emotes @ 100');
  });
});

test('show 3 emotes @ 1000', function (assert) {
  assert.expect(1);

  this.render(hbs`
    {{bits/available-emotes amount=1000}}
  `);

  return wait().then(() => {
    assert.equal(this.$().find('.bits-emotes__image').length, 3, '3 emotes @ 1000');
  });
});

test('show 4 emotes @ 5000', function (assert) {
  assert.expect(1);

  this.render(hbs`
    {{bits/available-emotes amount=5000}}
  `);

  return wait().then(() => {
    assert.equal(this.$().find('.bits-emotes__image').length, 4, '4 emotes @ 5000');
  });
});

test('show 5 emotes @ 10000', function (assert) {
  assert.expect(1);

  this.render(hbs`
    {{bits/available-emotes amount=10000}}
  `);

  return wait().then(() => {
    assert.equal(this.$().find('.bits-emotes__image').length, 5, '5 emotes @ 10000');
  });
});

test('show 0 emotes @ 0', function (assert) {
  assert.expect(1);

  this.render(hbs`
    {{bits/available-emotes amount=0}}
  `);

  return wait().then(() => {
    assert.equal(this.$().find('.bits-emotes__image').length, 0, '0 emotes @ 0');
  });
});
