import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import test from 'ember-sinon-qunit/test-support/test';
import hbs from 'htmlbars-inline-precompile';
import { getBitsString } from 'web-client/tests/helpers/bits-string';
import Service from 'ember-service';
import wait from 'ember-test-helpers/wait';

moduleForComponent('bits/bits-products', 'Integration | Component | bits/bits-products', {
  beforeEach() {
    this.defaultTemplate = hbs`{{bits/bits-products}}`;
  }
});

test('Clicking the Close Button closes Purchase Bits window', function (assert) {
  assert.expect(1);

  let mockBitsRoomServiceTwo = Service.extend({
    dismissBuyMenu() {
      assert.ok(true);
    }
  });
  this.owner.register('service:bits-room', mockBitsRoomServiceTwo);
  this.render(this.defaultTemplate);

  return wait().then(() => {
    this.$('#close-bits-purchase').click();
  });
});

test('Clicking the Buy Button closes Purchase Bits window', function (assert) {
  assert.expect(3);

  let stub = this.stub(window, 'open', () => {
    return {
      focus: function () {
        assert.ok(true);
      }
    };
  });

  let purchaseProducts = [
    { "amount": 100, "asin": "BT00LE2202", "price": "$1.40", "discount": 0, "show": false },
    { "amount": 500, "asin": "BT00LE25FY", "price": "$7.00", "discount": 0, "show": false },
    { "amount": 1500, "asin": "BT00LIUAUM", "price": "$19.95", "discount": 5, "show": true },
    { "amount": 5000, "asin": "BT00LN0NUE", "price": "$64.40", "discount": 8, "show": true },
    { "amount": 10000, "asin": "BT00LIUAZ2", "price": "$126.00", "discount": 10, "show": true },
    { "amount": 25000, "asin": "BT00LRG4MG", "price": "$308.00", "discount": 12, "show": true }
  ];
  let mockBitsRoomServiceTwo = Service.extend({
    purchaseProducts: purchaseProducts,
    dismissBuyMenu() {
      assert.ok(true);
    }
  });

  this.owner.register('service:bits-room', mockBitsRoomServiceTwo);
  this.render(this.defaultTemplate);

  return wait().then(() => {
    let button = purchaseProducts[0].asin;
    this.$(`#${button}`).click();

    assert.ok(stub.calledOnce, 'bits products was opened');
  });
});

test('Header subtext shows no minimum bits message', function (assert) {
  assert.expect(1);

  let balance = 1000;
  let mockBitsRoomServiceTwo = Service.extend({
    balance: balance
  });

  this.owner.register('service:bits-room', mockBitsRoomServiceTwo);
  this.render(this.defaultTemplate);

  return wait().then(() => {
    let $headerSubText = this.$().find('.tower:first-child .sub-text');

    let balanceText = getBitsString('inventory_footer', '', { balance: balance });
    let expectedText = this.$('<div></div>').html(balanceText).text();

    assert.elementText($headerSubText, expectedText, 'Only show balance');
  });
});

test('Header subtext shows minimum bits message', function (assert) {
  assert.expect(1);

  let balance = 1000;
  let minBits = 2;
  let channelName = 'channelName';

  let mockBitsRoomServiceTwo = Service.extend({
    balance: balance,
    minimumBits: minBits,
    channelDisplayName: channelName
  });

  this.owner.register('service:bits-room', mockBitsRoomServiceTwo);
  this.render(this.defaultTemplate);

  return wait().then(() => {
    let $headerSubText = this.$().find('.tower:first-child .sub-text');

    let balanceText = getBitsString('inventory_footer', '', {
      balance: balance
    });
    let minBitsText = getBitsString('inventory_footer_min_bits', '', {
      minBits: minBits,
      channelName: channelName
    });

    let expectedBalanceText = this.$('<div></div>').html(balanceText).text();
    let expectedMinBitsText = this.$('<div></div>').html(minBitsText).text();

    let regex = new RegExp(`${expectedBalanceText}\\s*${expectedMinBitsText}`);
    assert.ok(regex.test($headerSubText.text().trim()), 'Show balance with min bits');
  });
});
