import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';
import Service from 'ember-service';
import wait from 'ember-test-helpers/wait';

const serviceProps = [
  'hasPurpleFooter',
  'needsToSeeRecipientCanEnableFTUE',
  'needsToSeeFTUE',
  'needsToSeeAdsFTUE',
  'notLoggedIn',
  'isOwnChannel',
  'isSenderIneligible',
  'isRecipientIneligible',
  'isBalanceUnavailable',
  'delayedBitsMessageToSend',
  'showAsyncError',
  'isFetching',
  'isSendingBits',
  'isBuyingBits',
  'isShowingAdReward',
  'isShowingAdsForBitsError',
  'showInventory'
];

let renderTooltip = (module) => {
  module.owner.register('service:bits-room', Service.extend({
    unknownProperty(key) {
      return module.get(key);
    }
  }));

  module.render(hbs`{{bits/chat-tooltip}}`);
};

moduleForComponent('bits/chat-tooltip', 'Integration | Component | bits/chat tooltip', {
  beforeEach() {
    serviceProps.forEach((prop) => {
      this.set(prop, false);
    });

    // these 2 props are to prevent certain components from failing (TODO?)
    this.set('totalBitsInMessage', 1);
    this.set('ftueType', 'default');
  }
});

test('renders tooltip wrapper', function (assert) {
  assert.expect(1);

  renderTooltip(this);

  return wait().then(() => {
    assert.elementCount('.js-bits-tooltip-wrapper', 1);
  });
});

test('renders tooltip wrapper w/ purple arrow', function (assert) {
  assert.expect(1);

  this.set('hasPurpleFooter', true);
  renderTooltip(this);

  return wait().then(() => {
    assert.elementCount('.js-bits-tooltip-wrapper.bits-card--purple-arrow', 1);
  });
});

test('broadcaster not eligible but can enable FTUE', function (assert) {
  assert.expect(1);

  this.set('needsToSeeRecipientCanEnableFTUE', true);
  renderTooltip(this);

  return wait().then(() => {
    assert.elementCount('.js-bits-broadcaster-notification', 1);
  });
});

test('renders FTUE', function (assert) {
  assert.expect(1);

  this.set('needsToSeeFTUE', true);
  renderTooltip(this);

  return wait().then(() => {
    assert.elementCount('.js-bits-intro-promo', 1);
  });
});

test('renders ads FTUE', function (assert) {
  assert.expect(1);

  this.set('needsToSeeAdsFTUE', true);
  renderTooltip(this);

  return wait().then(() => {
    assert.elementCount('.js-bits-intro-promo-ads', 1);
  });
});

test('renders not logged in', function (assert) {
  assert.expect(1);

  this.set('notLoggedIn', true);
  renderTooltip(this);

  return wait().then(() => {
    assert.elementCount('.js-bits-not-logged-in', 1);
  });
});

test('renders sender ineligible', function (assert) {
  assert.expect(1);

  this.set('isSenderIneligible', true);
  renderTooltip(this);

  return wait().then(() => {
    assert.elementCount('.js-bits-ineligible-sender', 1);
  });
});

test('renders recipient ineligible', function (assert) {
  assert.expect(1);

  this.set('isRecipientIneligible', true);
  renderTooltip(this);

  return wait().then(() => {
    assert.elementCount('.js-bits-ineligible-recipient', 1);
  });
});

test('renders balance unavailable', function (assert) {
  assert.expect(1);

  this.set('isBalanceUnavailable', true);
  renderTooltip(this);

  return wait().then(() => {
    assert.elementCount('.js-bits-is-unavailable', 1);
  });
});

test('renders undo send prompt', function (assert) {
  assert.expect(1);

  this.set('delayedBitsSendAmount', 5);
  this.set('delayedBitsMessageToSend', 'hello');
  renderTooltip(this);

  return wait().then(() => {
    assert.elementCount('.js-bits-undo-prompt', 1);
  });
});

test('renders async error', function (assert) {
  assert.expect(1);

  this.set('showAsyncError', true);
  renderTooltip(this);

  return wait().then(() => {
    assert.elementCount('.js-bits-async-error', 1);
  });
});

test('renders fetching', function (assert) {
  assert.expect(1);

  this.set('isFetching', true);
  renderTooltip(this);

  return wait().then(() => {
    assert.elementCount('.js-bits-fetching-prompt', 1);
  });
});

test('renders sending bits', function (assert) {
  assert.expect(1);

  this.set('isSendingBits', true);
  renderTooltip(this);

  return wait().then(() => {
    assert.elementCount('.js-bits-sending-bits', 1);
  });
});

test('renders buy menu', function (assert) {
  assert.expect(1);

  this.set('isBuyingBits', true);
  renderTooltip(this);

  return wait().then(() => {
    assert.elementCount('.js-bits-bits-products', 1);
  });
});

test('renders ad reward', function (assert) {
  assert.expect(1);

  this.set('adReward', 5);
  this.set('isShowingAdReward', true);
  renderTooltip(this);

  return wait().then(() => {
    assert.elementCount('.js-bits-ads-reward', 1);
  });
});

test('renders watch ad error', function (assert) {
  assert.expect(1);

  this.set('isShowingAdsForBitsError', true);
  renderTooltip(this);

  return wait().then(() => {
    assert.elementCount('.js-bits-watch-ad-error', 1);
  });
});

test('renders own channel', function (assert) {
  assert.expect(1);

  this.set('isOwnChannel', true);
  renderTooltip(this);

  return wait().then(() => {
    assert.elementCount('.js-bits-own-channel', 1);
  });
});

test('renders inventory footer', function (assert) {
  assert.expect(1);

  this.set('showInventory', true);
  renderTooltip(this);

  return wait().then(() => {
    assert.elementCount('.js-bits-inventory-footer', 1);
  });
});
