import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';
import wait from 'ember-test-helpers/wait';
import Service from 'ember-service';
import { BITS_URL } from 'web-client/utilities/urls/static-cdn';
import { CHEERMOTE_BG_DARK, CHEERMOTE_BG_LIGHT } from 'web-client/utilities/bits/constants-config';
import { getBitsString } from 'web-client/tests/helpers/bits-string';

moduleForComponent('bits/cheering-tutorial', 'Integration | Component | bits/cheering tutorial', {
  beforeEach() {
    this.owner.register('service:bits-room', Service.extend({
      channelDisplayName: 'gachi'
    }));
  }
});

test('it renders', function (assert) {
  assert.expect(7);

  this.render(hbs`{{bits/cheering-tutorial}}`);

  return wait().then(() => {
    assert.elementCount(this.$('img'), 1, 'image');
    assert.elementCount(this.$('header'), 1, 'header');
    assert.elementCount(this.$('p.bits-card-landing__text'), 1, 'subtext');

    assert.equal(this.$('img').attr('src'), `${BITS_URL}/${CHEERMOTE_BG_LIGHT}/animated/1/cheertutorial.gif`, 'image src');
    assert.elementText(this.$('header'), getBitsString('needs_command_header'));
    assert.elementText(this.$('p'), getBitsString('needs_command_prompt', '', { channelName: 'gachi' }));

    // turn dark mode on
    this.owner.lookup('service:bits-emotes').set('isDarkChat', true);
    return wait();
  }).then(() => {
    assert.equal(this.$('img').attr('src'), `${BITS_URL}/${CHEERMOTE_BG_DARK}/animated/1/cheertutorial.gif`, 'image src');
  });
});
