import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';
import wait from 'ember-test-helpers/wait';
import Service from 'ember-service';
import { getBitsString } from 'web-client/tests/helpers/bits-string';

moduleForComponent('bits/cheermote-spotlight', 'Integration | Component | bits/cheermote spotlight', {
  beforeEach() {
    this.owner.register('service:bits-room', Service.extend({
      isCheerMessage: false,
      isCheerAboveMax: false,
      channelDisplayName: 'Gachi',
      isMaxMessageLengthExceeded: false,
      isCheerZero: false,
      isCheerBelowMinEmote: false,
      isCheerBelowMinimum: false,
      isBalanceExceeded: false,
      balanceExceededAmount: 0,
      prefix: 'Kappa',
      totalBitsInMessage: 123,
      shouldShowBitsTotal: false,
      minimumBitsEmote: 1,
      numBitsToMinimum: 0,
      numBitsToPinMinimum: 0
    }));
  }
});

test('render prefix', function (assert) {
  assert.expect(5);

  this.prefix = 'Kreygasm';
  this.useDarkAssets = false;
  this.render(hbs`
    {{bits/cheermote-spotlight
        prefix=prefix
        useDarkAssets=useDarkAssets}}
    `);

  return wait().then(() => {
    assert.elementCount(this.$('header'), 1, 'header');
    assert.elementText(this.$('header'), this.prefix, 'prefix in header');

    assert.elementCount(this.$('img'), 1, 'image');

    let expectedSrc = this.owner.lookup('service:bits-emotes').getImageSrc(100, 'Kreygasm', false, false, 4);
    assert.equal(this.$('img').attr('src'), expectedSrc, 'image src');

    // change prefix and dark mode
    this.set('prefix', 'Kappa');
    this.owner.lookup('service:bits-emotes').set('isDarkChat', true);

    return wait();
  }).then(() => {
    let expectedSrc = this.owner.lookup('service:bits-emotes').getImageSrc(100, 'Kappa', true, false, 4);
    assert.equal(this.$('img').attr('src'), expectedSrc, 'image src');
  });
});

test('render prefix+value', function (assert) {
  assert.expect(3);

  this.prefix = 'Gachi';
  this.cheermoteValue = '10000';
  this.render(hbs`
    {{bits/cheermote-spotlight
        prefix=prefix
        cheermoteValue=cheermoteValue}}
    `);

  return wait().then(() => {
    assert.elementCount(this.$('header'), 1, 'header');
    assert.elementText(this.$('header'), `${this.prefix}${this.cheermoteValue}`, 'prefix and amount in header');
    assert.elementCount(this.$('.js-bits-cheermote-with-amount'), 1, 'cheermote-with-amount component');
  });
});

test('current cheer w/ fatal errors', function (assert) {
  assert.expect(6);

  this.owner.lookup('service:bits-room').set('isCheerMessage', true);
  this.owner.lookup('service:bits-room').set('isMaxMessageLengthExceeded', true);
  this.render(hbs`{{bits/cheermote-spotlight useCurrentCheer=true}}`);

  return wait().then(() => {
    assert.elementCount(this.$('header'), 1, 'header');
    assert.elementText(this.$('header'), getBitsString('cheermote_spotlight_yours'), 'header text');
    assert.elementCount(this.$('section'), 1, 'section');
    assert.elementText(this.$('section'), getBitsString('max_length_exceeded'), 'max length exceeded error');

    this.owner.lookup('service:bits-room').set('isMaxMessageLengthExceeded', false);
    this.owner.lookup('service:bits-room').set('isCheerAboveMax', true);

    return wait();
  }).then(() => {
    assert.elementText(this.$('section'), getBitsString('above_max'), 'cheer above max error');

    this.owner.lookup('service:bits-room').set('isCheerAboveMax', false);
    this.owner.lookup('service:bits-room').set('isCheerZero', true);

    return wait();
  }).then(() => {
    assert.elementText(this.$('section'), getBitsString('zero'), 'cheer0 error');
  });
});

test('current cheer w/ below min error', function (assert) {
  assert.expect(7);

  this.owner.lookup('service:bits-room').set('isCheerMessage', true);
  this.owner.lookup('service:bits-room').set('isCheerBelowMinEmote', true);
  this.owner.lookup('service:bits-room').set('isCheerBelowMinimum', true);
  this.owner.lookup('service:bits-room').set('numBitsToMinimum', 1);
  this.owner.lookup('service:bits-room').set('numBitsToPinMinimum', 1);
  this.render(hbs`{{bits/cheermote-spotlight useCurrentCheer=true}}`);

  return wait().then(() => {
    assert.elementCount(this.$('header'), 1, 'header');
    assert.elementText(this.$('header'), getBitsString('cheermote_spotlight_yours'), 'header text');

    assert.elementText(this.$('section p').eq(0), getBitsString('min_bits_emotes', '', {minBitsEmote: 1}), 'min bits emote error');
    assert.elementText(this.$('section p').eq(1), getBitsString('num_bits_to_min_pin', '', {numBitsToMin: 1}), 'num bits to pin cheer');

    this.owner.lookup('service:bits-room').set('isCheerBelowMinEmote', false);

    return wait();
  }).then(() => {
    assert.elementText(this.$('section p').eq(0), getBitsString('num_bits_to_min', '', {numBitsToMin: 1}), 'num bits to reach minimum');

    this.owner.lookup('service:bits-room').set('numBitsToPinMinimum', 0);

    return wait();
  }).then(() => {
    assert.elementText(this.$('section p').eq(0), getBitsString('num_bits_to_min', '', {numBitsToMin: 1}), 'num bits to reach minimum');
    assert.elementCount(this.$('section p'), 1, 'no amount to pin cheer');
  });
});

test('current cheer w/ valid cheer', function (assert) {
  assert.expect(8);

  this.owner.lookup('service:bits-room').set('isCheerMessage', true);
  this.owner.lookup('service:bits-room').set('shouldShowBitsTotal', false);
  this.render(hbs`{{bits/cheermote-spotlight useCurrentCheer=true}}`);

  return wait().then(() => {
    assert.elementCount(this.$('header'), 1, 'header');
    assert.elementText(this.$('header'), getBitsString('cheermote_spotlight_yours'), 'header text');
    assert.elementCount(this.$('section div .js-bits-cheermote-with-amount'), 1, 'rendered cheermote-with-amount component');

    this.owner.lookup('service:bits-room').set('shouldShowBitsTotal', true);
    return wait();
  }).then(() => {
    assert.elementText(this.$('section p'), getBitsString('send_amount_total', '', { amount: 123, channelName: 'Gachi' }), 'bits total text instead of cheermote component');

    this.owner.lookup('service:bits-room').set('isBalanceExceeded', true);
    this.owner.lookup('service:bits-room').set('balanceExceededAmount', 420);
    return wait();
  }).then(() => {
    assert.elementCount(this.$('section p'), 2, '2 paragraphs now, error and bits total text');
    assert.elementText(this.$('section p').eq(0), getBitsString('balance_exceeded', '', { requiredBalance: 420 }), 'balance exceeded text');

    this.owner.lookup('service:bits-room').set('isBalanceExceeded', false);
    this.owner.lookup('service:bits-room').set('balanceExceededAmount', 0);
    this.owner.lookup('service:bits-room').set('numBitsToPinMinimum', 420);
    return wait();
  }).then(() => {
    assert.elementCount(this.$('section p'), 2, '2 paragraphs still, error and bits total text');
    assert.elementText(this.$('section p').eq(0), getBitsString('num_bits_to_min_pin', '', { numBitsToMin: 420 }), 'num bits to pin cheer');
  });
});

