import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';
import wait from 'ember-test-helpers/wait';

moduleForComponent('bits/cheermote-with-amount', 'Integration | Component | bits/cheermote with amount');

test('it renders', function (assert) {
  assert.expect(6);

  this.prefix = 'Kappa';
  this.amount = 123;

  this.render(hbs`{{bits/cheermote-with-amount amount=amount prefix=prefix}}`);

  return wait().then(() => {
    let $img = this.$('img');
    let $amount = this.$('strong');

    assert.elementCount($img, 1, 'image');
    assert.elementCount($amount, 1, 'amount');

    let expectedImgSrc = this.owner.lookup('service:bits-emotes').getImageSrc(123, 'Kappa', false, false, 4);
    let expectedAmtColor = this.owner.lookup('service:bits-emotes').getTierColor(123, 'Kappa');

    assert.equal($img.attr('src'), expectedImgSrc, 'img src');
    assert.equal($amount.attr('style'), `color:${expectedAmtColor}`, 'amount style');
    assert.elementText($amount, `${this.amount}`, 'amount text');

    // change to dark mode
    this.owner.lookup('service:bits-emotes').set('isDarkChat', true);
    this.set('prefix', 'Kreygasm');

    return wait();
  }).then(() => {
    let expectedImgSrc = this.owner.lookup('service:bits-emotes').getImageSrc(123, 'Kreygasm', true, false, 4);
    assert.equal(this.$('img').attr('src'), expectedImgSrc, 'img src (dark assets)');
  });
});
