import { moduleForComponent, test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';

moduleForComponent('bits/content-wrapper', 'Integration | Component | bits/content wrapper', {
  integration: true
});

test('default', function(assert) {
  this.render(hbs`
    {{#bits/content-wrapper}}
      content here
    {{/bits/content-wrapper}}
  `);

  assert.elementCount(this.$().find('.bits-card--standard .bits-card__contain'), 1);
  assert.elementText(this.$().find('.bits-card--standard .bits-card__contain'), 'content here');
});

test('no contain', function(assert) {
  this.render(hbs`
    {{#bits/content-wrapper noContain=true}}
      content here
    {{/bits/content-wrapper}}
  `);

  assert.elementCount(this.$().find('.bits-card--standard .bits-card__contain'), 0);
  assert.elementCount(this.$().find('.bits-card--standard'), 1);
  assert.elementText(this.$().find('.bits-card--standard'), 'content here');
});
