import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';
import wait from 'ember-test-helpers/wait';
import { CHEER_PREFIX } from 'web-client/utilities/bits/constants-config';

moduleForComponent('bits/emote-amount', 'Integration | Component | bits/emote amount');

test('it renders', function (assert) {
  assert.expect(2);
  this.render(hbs`{{bits/emote-amount amount=1000}}`);

  return wait().then(() => {
    let expectedColor = this.owner.lookup('service:bits-emotes').getTierColor(1000, CHEER_PREFIX);

    assert.elementText(this.$('.js-bits-emote-amount'), '1000', 'amount');
    assert.equal(this.$('.js-bits-emote-amount').attr('style'), `color:${expectedColor}`, 'color');
  });
});
