import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';
import wait from 'ember-test-helpers/wait';
import { CHEER_PREFIX } from 'web-client/utilities/bits/constants-config';

moduleForComponent('bits/emote-image', 'Integration | Component | bits/emote image');

test('renders normally', function (assert) {
  assert.expect(2);

  this.render(hbs`{{bits/emote-image amount=100}}`);

  return wait().then(() => {
    let expectedSrc = this.owner.lookup('service:bits-emotes').getImageSrc(100, CHEER_PREFIX, false, false, 1);
    assert.equal(this.$('img').attr('src'), expectedSrc, 'src correct');
    assert.equal(this.$('img').attr('srcset'), undefined, 'no srcset');
  });
});

test('include srcset', function (assert) {
  assert.expect(2);

  this.render(hbs`{{bits/emote-image amount=100 includeSrcSet=true}}`);

  return wait().then(() => {
    let svc = this.owner.lookup('service:bits-emotes');
    let expectedSrc = svc.getImageSrc(100, CHEER_PREFIX, false, false, 1);
    let expectedSrcSet = svc.getImageSrcSet(100, CHEER_PREFIX, false, false, 1);

    assert.equal(this.$('img').attr('src'), expectedSrc);
    assert.equal(this.$('img').attr('srcset'), expectedSrcSet, 'no srcset');
  });
});

test('dark assets override', function (assert) {
  assert.expect(1);

  this.owner.lookup('service:bits-emotes').set('isDarkChat', false);
  this.render(hbs`{{bits/emote-image amount=100 useDarkAssetsOverride=true}}`);

  return wait().then(() => {
    let expectedSrc = this.owner.lookup('service:bits-emotes').getImageSrc(100, CHEER_PREFIX, true, false, 1);
    assert.equal(this.$('img').attr('src'), expectedSrc);
  });
});
