import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';
import wait from 'ember-test-helpers/wait';
import Service from 'ember-service';
import { getBitsString } from 'web-client/tests/helpers/bits-string';

moduleForComponent('bits/emote-tiers-intro', 'Integration | Component | bits/emote tiers intro', {
  beforeEach() {
    this.owner.register('service:bits-room', Service.extend({
      minimumBits: 1,
      showMinBitsPinned: false
    }));
    this.owner.register('service:bits-pinned-cheers', Service.extend({
      channelMinimum: 1
    }));
  }
});

test('renders no minimum', function (assert) {
  assert.expect(2);

  this.render(hbs`{{bits/emote-tiers-intro}}`);

  return wait().then(() => {
    assert.elementCount(this.$('.bits-card-landing__text'), 1, 'intro paragraph');
    assert.ok(this.$('.bits-card-landing__text').hasClass('pd-t-8'), 'correct padding on intro paragraph');
  });
});

test('renders min bits or min pinned cheers (not both)', function (assert) {
  assert.expect(6);

  let minBitsString = getBitsString('min_bits', '', {minBits: 2});

  this.owner.lookup('service:bits-room').set('minimumBits', 2);
  this.render(hbs`{{bits/emote-tiers-intro}}`);

  return wait().then(() => {
    let $intro = this.$('.bits-card-landing__text').eq(0);
    let $mins = this.$('.bits-card-landing__text').eq(1);

    assert.elementCount(this.$('.bits-card-landing__text'), 2, 'intro and minimum paragraphs');
    assert.ok($intro.hasClass('pd-t-6'), 'correct padding on intro paragraph');
    assert.stringIncludes($mins.text(), minBitsString, 'min bits');

    this.owner.lookup('service:bits-room').set('minimumBits', 1);
    this.owner.lookup('service:bits-room').set('showMinBitsPinned', true);
    return wait();
  }).then(() => {
    let $intro = this.$('.bits-card-landing__text').eq(0);
    let $mins = this.$('.bits-card-landing__text').eq(1);
    let minPinnedString = getBitsString('min_bits_pcheer', '', {minBits: 1});

    assert.elementCount(this.$('.bits-card-landing__text'), 2, 'intro and minimum paragraphs');
    assert.ok($intro.hasClass('pd-t-6'), 'correct padding on intro paragraph');
    assert.stringIncludes($mins.text(), minPinnedString, 'min pinned cheer');
  });
});

test('renders min bits and min pinned cheers', function (assert) {
  assert.expect(4);

  let minBitsString = getBitsString('min_bits', '', {minBits: 2});
  let minPinnedString = getBitsString('min_bits_pcheer', '', {minBits: 2});

  this.owner.lookup('service:bits-room').set('minimumBits', 2);
  this.owner.lookup('service:bits-room').set('showMinBitsPinned', true);
  this.owner.lookup('service:bits-pinned-cheers').set('channelMinimum', 2);

  this.render(hbs`{{bits/emote-tiers-intro}}`);

  let $intro = this.$('.bits-card-landing__text').eq(0);
  let $mins = this.$('.bits-card-landing__text').eq(1);

  return wait().then(() => {
    assert.elementCount(this.$('.bits-card-landing__text'), 2, 'intro and minimum paragraphs');
    assert.ok($intro.hasClass('pd-t-5'), 'correct padding on intro paragraph');

    let minsText = $mins.text();
    assert.stringIncludes(minsText, minBitsString, 'min bits');
    assert.stringIncludes(minsText, minPinnedString, 'min pinned cheer');
  });
});
