import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';
import { CHEER_PREFIX } from 'web-client/utilities/bits/constants-config';

moduleForComponent('bits/interactive-cheermote', 'Integration | Component | bits/interactive cheermote');

test('defaults properties', function (assert) {
  let defaultCheermoteSrc = this.owner.lookup('service:bits-emotes').getImageSrc(100, CHEER_PREFIX, false, true, 2);

  this.render(hbs`{{bits/interactive-cheermote}}`);

  assert.elementCount(this.$('button'), 1, 'button');
  assert.elementCount(this.$('img'), 1, 'image');
  assert.equal(this.$('img').attr('src'), defaultCheermoteSrc, 'correct source');
});

test('not default properties', function (assert) {
  this.prefix = 'SwiftRage';
  this.amount = 10000;
  this.state = 'animated';
  this.size = 4;
  this.owner.lookup('service:bits-emotes').set('isDarkChat', true);

  let expectedImgSrc = this.owner.lookup('service:bits-emotes').getImageSrc(10000, 'SwiftRage', true, false, 4);

  this.render(hbs`
    {{bits/interactive-cheermote
      prefix=prefix
      amount=amount
      state=state
      size=size}}
    `);

  assert.elementCount(this.$('button'), 1, 'button');
  assert.elementCount(this.$('img'), 1, 'image');
  assert.equal(this.$('img').attr('src'), expectedImgSrc, 'correct source');
});
