import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';
import Service from 'ember-service';
import wait from 'ember-test-helpers/wait';

moduleForComponent('bits-promo', 'Integration | Component | bits/intro-promo', {
  beforeEach() {
    this.defaultTemplate = hbs`{{bits/intro-promo}}`;
  }
});

test('Renders all default pages', function (assert) {
  assert.expect(3);

  let mockBitsRoomService = Service.extend({
    ftueType: 'default'
  });
  this.owner.register('service:bits-room', mockBitsRoomService);
  this.render(this.defaultTemplate);

  return wait().then(() => {
    let pageOneBody = this.$('<div></div>').html('promo_card_one_body').text();
    let pageTwoBody = this.$('<div></div>').html('promo_card_two_body').text();
    let pageThreeBody = this.$('<div></div>').html('promo_card_three_body').text();

    assert.equal(this.$('.bits-card__text').text().trim(), pageOneBody);

    this.$('.bits-promo__action button').click();
    assert.equal(this.$('.bits-card__text').text().trim(), pageTwoBody);

    this.$('.bits-promo__action button').click();
    assert.equal(this.$('.bits-card__text').text().trim(), pageThreeBody);
  });
});

test('Able to exit by clicking the <x> button', function (assert) {
  assert.expect(1);

  let mockBitsRoomService = Service.extend({
    ftueType: 'default',
    dismissFTUE() {
      assert.ok(true);
    }
  });
  this.owner.register('service:bits-room', mockBitsRoomService);
  this.render(this.defaultTemplate);

  return wait().then(() => {
    this.$('.bits-promo__close').click();
  });
});

test('Complete promo by hitting the button 3 times', function (assert) {
  assert.expect(1);

  let mockBitsRoomService = Service.extend({
    ftueType: 'default',
    completeFTUE() {
      assert.ok(true);
    }
  });
  this.owner.register('service:bits-room', mockBitsRoomService);
  this.render(this.defaultTemplate);

  return wait().then(() => {
    this.$('.bits-promo__action button').click();
    this.$('.bits-promo__action button').click();
    this.$('.bits-promo__action button').click();
  });
});
