import { test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';
import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { getBitsString } from 'web-client/tests/helpers/bits-string';
import Service from 'ember-service';
import wait from 'ember-test-helpers/wait';

moduleForComponent('bits/inventory-footer', 'Integration | Component | bits/inventory-footer', {
  beforeEach() {
    this.defaultTemplate = hbs`{{bits/inventory-footer}}`;
  }
});

test('Renders balance no cheer emote with 0 balance', function (assert) {
  assert.expect(2);

  let mockBitsRoomService = Service.extend({
    balance: 0,
    mininumBits: 1
  });
  this.owner.register('service:bits-room', mockBitsRoomService);
  this.render(this.defaultTemplate);

  return wait().then(() => {
    assert.stringIncludes(this.$('.bits-footer__actions').text().trim(), getBitsString('you_have'));
    assert.stringIncludes(this.$('.bits-footer__actions').text().trim(), getBitsString('total_bits', '', { balance: 0 }));
  });
});

test('Renders cheer emote with balance greater than 0', function (assert) {
  assert.expect(1);

  let mockBitsRoomService = Service.extend({
    balance: 1,
    minimumBits: 1
  });
  this.owner.register('service:bits-room', mockBitsRoomService);
  this.render(this.defaultTemplate);

  return wait().then(() => {
    assert.elementCount(this.$('.bits-footer__actions .js-bits-emote-image'), 1, 'bits/emote-image component rendered');
  });
});

test('Does not render badge progress if no thresholds', function (assert) {
  assert.expect(1);

  let mockBitsRoomService = Service.extend({
    enabledBadgeTiers: []
  });
  this.owner.register('service:bits-room', mockBitsRoomService);
  this.render(this.defaultTemplate);

  return wait().then(() => {
    assert.elementCount(this.$('.bits-footer__badge-container'), 0);
  });
});

test('Does not render badge progress if only badge is grey and user has no badge', function (assert){
  assert.expect(1);

  let mockBitsRoomService = Service.extend({
    enabledBadgeTiers: [1],
    highestBitsBadge: 0
  });
  this.owner.register('service:bits-room', mockBitsRoomService);
  this.render(this.defaultTemplate);

  return wait().then(() => {
    assert.elementCount(this.$('.bits-footer__badge-container'), 0);
  });
});

test('Current badge renders when user has one', function(assert) {
  assert.expect(1);

  let mockBitsRoomService = Service.extend({
    enabledBadgeTiers: [1,100,1000],
    highestBitsBadge: 100,
    channelTotal: 100,
    globalBadges: { bits: { versions: {
            100: { image_url_1x: "https://static-cdn.jtvnw.net/badges/v1/09d93036-e7ce-431c-9a9e-7044297133f2/1"},
            1000: { image_url_1x: "https://static-cdn.jtvnw.net/badges/v1/0d85a29e-79ad-4c63-a285-3acd2c66f2ba/1"}
          }}}
  });
  this.owner.register('service:bits-room', mockBitsRoomService);
  this.render(this.defaultTemplate);

  return wait().then(() => {
    assert.elementCount(this.$('.bits-footer__current-badge'), 1);
  });
});

test('Current badge does not appear when user has none', function(assert) {
  assert.expect(1);

  let mockBitsRoomService = Service.extend({
    enabledBadgeTiers: [1,100,1000],
    highestBitsBadge: 0,
    channelTotal: 0,
    globalBadges: { bits: { versions: {
            100: { image_url_1x: "https://static-cdn.jtvnw.net/badges/v1/09d93036-e7ce-431c-9a9e-7044297133f2/1"},
            1000: { image_url_1x: "https://static-cdn.jtvnw.net/badges/v1/0d85a29e-79ad-4c63-a285-3acd2c66f2ba/1"}
          }}}
  });
  this.owner.register('service:bits-room', mockBitsRoomService);
  this.render(this.defaultTemplate);

  return wait().then(() => {
    assert.elementCount(this.$('.bits-footer__current-badge'), 0);
  });
});

test('Next badge renders when user needs one', function(assert) {
  assert.expect(1);

  let mockBitsRoomService = Service.extend({
    enabledBadgeTiers: [1,100,1000],
    highestBitsBadge: 0,
    channelTotal: 0,
    channelDisplayName: "qa_bits_partner",
    globalBadges: { bits: { versions: {
            100: { image_url_1x: "https://static-cdn.jtvnw.net/badges/v1/09d93036-e7ce-431c-9a9e-7044297133f2/1"},
            1000: { image_url_1x: "https://static-cdn.jtvnw.net/badges/v1/0d85a29e-79ad-4c63-a285-3acd2c66f2ba/1"}
          }}}
  });
  this.owner.register('service:bits-room', mockBitsRoomService);
  this.render(this.defaultTemplate);

  return wait().then(() => {
    assert.elementCount(this.$('.bits-footer__next-badge-container'), 1);
  });
});

test('Next badge does not render when user reached max badges', function(assert) {
  assert.expect(1);

  let mockBitsRoomService = Service.extend({
    enabledBadgeTiers: [1,100,1000],
    highestBitsBadge: 1000,
    channelTotal: 2000,
    channelDisplayName: "qa_bits_partner",
    globalBadges: { bits: { versions: {
            100: { image_url_1x: "https://static-cdn.jtvnw.net/badges/v1/09d93036-e7ce-431c-9a9e-7044297133f2/1"},
            1000: { image_url_1x: "https://static-cdn.jtvnw.net/badges/v1/0d85a29e-79ad-4c63-a285-3acd2c66f2ba/1"}
          }}}
  });
  this.owner.register('service:bits-room', mockBitsRoomService);
  this.render(this.defaultTemplate);

  return wait().then(() => {
    assert.elementCount(this.$('.bits-footer__next-badge-container'), 0);
  });
});
