import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';
import { getBitsString } from 'web-client/tests/helpers/bits-string';
import wait from 'ember-test-helpers/wait';

moduleForComponent('bits/pinned-cheers/intro-viewer', 'Integration | Component | bits/pinned cheers/intro viewer');

test('Renders elements, text, and close button', function (assert) {
  assert.expect(6);

  this.learnMoreUrl = 'https://www.twitch.tv';
  this.on('close', () => {
    assert.ok(true, 'Pass-thru close action invoked');
  });
  this.render(hbs`
    {{bits/pinned-cheers/intro-viewer
      learnMoreUrl=learnMoreUrl
      close=(action 'close')}}
  `);

  return wait().then(() => {
    let desc = this.$().find('.pinned-cheers-intro__viewer-desc');
    assert.elementCount('.pinned-cheers-intro__viewer-desc', 1, 'Description');
    assert.stringIncludes(desc.text(), getBitsString('pcheers_chat_viewer_intro_no_min'), 'Description text');

    let learnMoreLink = desc.find('a');
    assert.equal(learnMoreLink.text(), getBitsString('pcheers_chat_learn_more'), 'Learn more text');
    assert.equal(learnMoreLink.attr('href'), this.learnMoreUrl, 'Learn more URL');

    assert.elementCount('.pinned-cheers-intro__close', 1, 'Close button');
    this.$().find('.pinned-cheers-intro__close').click();
  });
});
