import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';
import Service from 'ember-service';
import RSVP from 'rsvp';
import wait from 'ember-test-helpers/wait';
import { PINNED_CHEER_TYPES } from 'web-client/utilities/bits/constants-config';
import { AuthenticatedSession, userData } from 'web-client/tests/helpers/mock-session-service';
import { getBitsString } from 'web-client/tests/helpers/bits-string';

moduleForComponent('bits/pinned-cheers/reset-top-cheer-dialog', 'Integration | Component | bits/pinned cheers/reset top cheer dialog');

test('it renders and actions invoked', function (assert) {
  assert.expect(6);

  this.owner.register('service:session', AuthenticatedSession);
  this.owner.register('service:bits-pinned-cheers', Service.extend({
    dismissMessage(userId, type) {
      assert.equal(userId, userData.id, 'userId of the dismisser');
      assert.equal(type, PINNED_CHEER_TYPES.TOP, 'top cheer was dismissed');

      return RSVP.resolve({});
    }
  }));

  this.set('options', {
    renderTop: 1,
    renderLeft: 1,
    channelName: 'partner',
    username: 'user',
    cheerAmount: '50'
  });
  this.on('hide', () => {
    assert.ok(true, 'hide invoked');
  });

  this.render(hbs`
    {{bits/pinned-cheers/reset-top-cheer-dialog
      options=options
      hide=(action 'hide')}}`);

  let stringArgs = {
    username: this.get('options.username'),
    cheerAmount: this.get('options.cheerAmount'),
    channelName: this.get('options.channelName')
  };

  return wait().then(() => {
    assert.equal(this.$('.js-bits-reset-top-cheer-dialog').attr('style'), `top:1px;left:1px`, 'position attributes');
    assert.elementText(this.$('p'), getBitsString('top_cheer_reset_confirm', "This will permanently remove %{username}'s Top Cheer (%{cheerAmount} Bits) for everyone in %{channelName}'s channel. Are you sure?", stringArgs), 'message');

    let $yes = this.$('button').eq(0);
    let $no = this.$('button').eq(1);

    // hide is invoked - 1 assert
    $no.click();

    // dismissMessage is invoked - 3 asserts (2 from dismissing then 1 from hiding after dismiss promise resolves)
    $yes.click();
  });
});
