import { moduleForComponent, test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';

moduleForComponent('bits/tooltip-footer', 'Integration | Component | bits/tooltip footer', {
  integration: true
});

test('default usage', function (assert) {
  this.render(hbs`
    {{#bits/tooltip-footer}}
      hello
    {{/bits/tooltip-footer}}
  `);

  assert.elementCount(this.$().find('.bits-footer'), 1, 'has base class');
  assert.elementCount(this.$().find('.bits-footer.bits-footer--button-only'), 0, 'no button only class');
  assert.equal(this.$().text().trim(), 'hello', 'yields block text');
});

test('button only', function (assert) {
  this.render(hbs`
    {{bits/tooltip-footer buttonOnly=true}}
  `);

  assert.elementCount(this.$().find('.bits-footer'), 1, 'has base class');
  assert.elementCount(this.$().find('.bits-footer.bits-footer--button-only'), 1, 'has button only class');
});
