import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';
import sinon from 'sinon';
import { getBitsString } from 'web-client/tests/helpers/bits-string';
import { AD_ERROR_TYPES } from 'web-client/components/bits/watch-ad-error/component';
import { BITS_URL } from 'web-client/utilities/urls/static-cdn';
import Service from 'ember-service';

const genericImageUrl = `${BITS_URL}/light/static/1/adserrorgeneric.png`;
const adblockImageUrl = `${BITS_URL}/light/static/1/adserroradblock.png`;

moduleForComponent('bits/watch-ad-error', 'Integration | Component | bits/watch ad error');

test('buttons', function (assert) {
  const tryAgain = sinon.stub();
  const close = sinon.stub();

  this.owner.register('service:bits-room', Service.extend({
    dismissTooltip: close,
    hideAdError: tryAgain
  }));
  this.render(hbs`{{bits/watch-ad-error}}`);

  let tryAgainBtn = this.$().find('button.button');
  let closeBtn = this.$().find('.bits-card__close');

  tryAgainBtn.click();
  closeBtn.click();

  assert.ok(tryAgain.calledOnce, 'tryAgain action was invoked once');
  assert.ok(close.calledOnce, 'close action was invoked once');
  assert.elementText(tryAgainBtn, getBitsString('button_try_again'), 'Try again button has correct text');
});

test('error type (exit early)', function (assert) {
  this.owner.register('service:bits-room', Service.extend({
    adsForBitsErrorType: AD_ERROR_TYPES.EXIT_EARLY
  }));
  this.render(hbs`{{bits/watch-ad-error}}`);

  let img = this.$().find('.bits-card__image--error img');
  let errorDesc = this.$().find('.bits-card__text--error');

  assert.equal(img.attr('src'), genericImageUrl, 'Image is correct for exiting ad early');
  assert.elementText(errorDesc, getBitsString('ads_error_exited_early'), 'Text is correct for exiting ad early');
});

test('error type (unknown)', function (assert) {
  this.owner.register('service:bits-room', Service.extend({
    adsForBitsErrorType: AD_ERROR_TYPES.UNKNOWN
  }));
  this.render(hbs`{{bits/watch-ad-error}}`);

  let img = this.$().find('.bits-card__image--error img');
  let errorDesc = this.$().find('.bits-card__text--error');

  assert.equal(img.attr('src'), genericImageUrl, 'Image is correct for unknown error');
  assert.elementText(errorDesc, getBitsString('ads_error_unknown'), 'Text is correct for unknown error');
});

test('error type (adblock)', function (assert) {
  this.owner.register('service:bits-room', Service.extend({
    adsForBitsErrorType: AD_ERROR_TYPES.ADBLOCK
  }));
  this.render(hbs`{{bits/watch-ad-error}}`);

  let img = this.$().find('.bits-card__image--error img');
  let errorDesc = this.$().find('.bits-card__text--error');

  assert.equal(img.attr('src'), adblockImageUrl, 'Image is correct for adblock');
  assert.elementText(errorDesc, getBitsString('ads_error_adblock'), 'Text is correct for adblock');
});
