import Service from 'ember-service';
import EmberObject from 'ember-object';
import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import hbs from 'htmlbars-inline-precompile';
import { test } from 'ember-qunit';
import sinon from 'sinon';
import { ARCHIVE_TYPE_PARAM } from 'web-client/utilities/video/types';

const DEFAULT_VIDEO_MODEL = {
    id: 234,
    type: ARCHIVE_TYPE_PARAM,
    owner: {
        id: 'fakeUser'
    },
    viewer: {
        id: 'fakeUser',
        isLoaded: true,
        is_editor: true
    },
    del() {}
};

const DEFAULT_CHANNEL_MODEL = {
    id: 'fakeUser'
};

let fakeSession = Service.extend({
    userData: {
        login: 'fakeUser'
    },
    isAuthenticated: true
});

let fakeRouter = EmberObject.extend({
    send() {}
});

moduleForComponent('channel-options', 'Integration | Component | channel options', {
    beforeEach() {
        this.register('service:session', fakeSession);
        this.owner.register('router:main', fakeRouter);
        this.set('channelModel', DEFAULT_CHANNEL_MODEL);
        this.set('videoModel', DEFAULT_VIDEO_MODEL);
        this.defaultTemplate = hbs`
            {{channel-options
                channel=channelModel
                video=videoModel
            }}
        `;
    }
});

test('can export, highlight, and delete when user is the vod owner', function(assert) {
    assert.expect(3);

    this.render(this.defaultTemplate);

    let optionsText = this.$('.js-channel-options').find('a.balloon__link').text();

    assert.ok(optionsText.indexOf('Highlight') > -1, 'shows highlight option');
    assert.ok(optionsText.indexOf('Export') > -1, 'shows export option');
    assert.ok(optionsText.indexOf('Delete') > -1, 'shows delete option');
});

test('sends openInModal route action when Delete is clicked', function(assert) {
    assert.expect(2);

    this.render(this.defaultTemplate);

    let options = this.$('.js-channel-options').find('a.balloon__link');
    let mainRouter = this.owner.lookup('router:main');
    sinon.spy(mainRouter, 'send');

    let numOptions = options.length;
    for (let i = 0; i < numOptions; i++) {
        let $node = this.$(options[i]);
        if ($node.text().indexOf('Delete') > -1) {
            $node.click();
            let callArgs = mainRouter.send.firstCall.args;
            assert.equal(callArgs[0], 'openInModal');
            assert.equal(callArgs[1], 'shared/delete_video');
            break;
        }
    }

    mainRouter.send.restore();
});

test('channel-option renders correctly', function(assert) {
    this.render(this.defaultTemplate);
    assert.ok(this.$('.js-channel-redesign').length > 0, 'shows redesign');
});
