import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';

moduleForComponent('channel-redesign/copy-icon', {
  beforeEach() {
    this.on('trackShare', () => this);
    this.on('selectCopyLink', () => this);
  }
});

test('copy-icon renders', function(assert) {
  this.render(hbs`{{channel-redesign/copy-icon}}`);
  assert.elementCount('button.js-copy-button', 1);
});

test('can pass text to copy', function(assert) {
  this.render(hbs`{{channel-redesign/copy-icon clipboardText="here's some copyable text"}}`);
  assert.equal(this.$('button.js-copy-button').attr('data-clipboard-text'), "here's some copyable text");
});

test('can pass trackShare action', function(assert) {
  this.render(hbs`{{channel-redesign/copy-icon clipboardText="here's some copyable text"
                                               trackShare=(action "trackShare")}}`);
  assert.elementCount('button.js-copy-button', 1);
});

test('can pass selectCopyLink action', function(assert) {
  this.render(hbs`{{channel-redesign/copy-icon clipboardText="here's some copyable text"
                                               trackShare=(action "trackShare")
                                               selectCopyLink=(action "selectCopyLink")
                                               }}`);
  assert.elementCount('button.js-copy-button', 1);
});
