import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { test } from 'ember-qunit';
import { assign } from 'ember-platform';
import hbs from 'htmlbars-inline-precompile';

moduleForComponent('channel-redesign/metadata-box');

function setupChannel(context, options = {}) {
  context.set('channel', assign(options, {
    views: 456
  }));
}

test('renders for offline channel', function(assert) {
  assert.expect(8);
  setupChannel(this);
  this.render(hbs`{{channel-redesign/metadata-box channel=channel}}`);

  assert.elementCount('.js-cn-metabar .js-cn-metabar__livecount', 0, 'current views does not render');
  assert.elementCount('.js-cn-metabar .js-cn-metabar__viewcount div:contains(456)', 1, 'total views renders');
  assert.elementCount('.js-cn-metabar .js-card__img--boxart', 0, 'box art does not render');
  assert.elementText('.js-cn-metabar .js-card__title', '', 'empty title renders');
  assert.elementText('.js-cn-metabar .js-card__body', '', 'empty stream data renders');
  assert.elementCount('.js-cn-metabar .js-share-box', 1, 'share box renders');
  assert.elementCount('.js-cn-metabar .js-channel-options', 1, 'channel options renders');
  assert.elementCount('.js-cn-metabar .js-cn-edit-link', 0, 'does not render edit button');
});

test('renders live count for online channel', function(assert) {
  assert.expect(1);
  setupChannel(this, {
    stream: {
      viewers: 123
    }
  });

  this.render(hbs`{{channel-redesign/metadata-box channel=channel}}`);
  assert.elementCount('.js-cn-metabar .js-cn-metabar__livecount div:contains(123)', 1, 'live count renders');
});

test('renders title if status is set for channel', function(assert) {
  assert.expect(1);
  setupChannel(this, {
    status: 'AMERICA!'
  });

  this.render(hbs`{{channel-redesign/metadata-box channel=channel}}`);
  assert.elementText('.js-cn-metabar .js-card__title', 'AMERICA!', 'renders title');
});

test('renders team', function(assert) {
  assert.expect(2);
  setupChannel(this, {
    primaryTeamName: 'staff',
    primaryTeamDisplayName: 'Twitch Staff'
  });

  this.render(hbs`{{channel-redesign/metadata-box channel=channel}}`);

  assert.elementCount('.js-cn-metabar .js-card__info a:contains(Twitch Staff)', 1, 'renders team link');
  assert.elementText('.js-cn-metabar .js-card__info a', 'Twitch Staff', 'renders team copy');
});

test('renders game info', function(assert) {
  assert.expect(3);
  setupChannel(this, {
    game: 'Counter Strike'
  });

  this.render(hbs`{{channel-redesign/metadata-box channel=channel}}`);

  assert.elementCount('.js-cn-metabar a:has(img[src="https://static-cdn.jtvnw.net/ttv-boxart/Counter%20Strike-138x190.jpg"])', 1, 'renders box art with link');
  assert.elementCount('.js-cn-metabar .js-card__info a:contains(Counter Strike)', 1, 'renders game link');
  assert.elementText('.js-cn-metabar .js-card__info a', 'Counter Strike', 'renders stream data copy');
});

test('renders game and team together', function(assert) {
  assert.expect(3);
  setupChannel(this, {
    game: 'Counter Strike',
    primaryTeamName: 'staff',
    primaryTeamDisplayName: 'Twitch Staff'
  });

  this.render(hbs`{{channel-redesign/metadata-box channel=channel}}`);

  assert.elementCount('.js-cn-metabar a:has(img[src="https://static-cdn.jtvnw.net/ttv-boxart/Counter%20Strike-138x190.jpg"])', 1, 'renders box art with link');
  assert.elementCount('.js-cn-metabar a:contains(Counter Strike)', 1, 'renders game link');
  assert.elementCount('.js-cn-metabar .js-card__info a:contains(Twitch Staff)', 1, 'renders team link');
});

test('renders edit button if `isEditable` is set', function(assert) {
  assert.expect(1);
  setupChannel(this);

  this.render(hbs`{{channel-redesign/metadata-box channel=channel isEditable=true}}`);

  assert.elementCount('.js-cn-metabar .js-cn-edit-link', 1, 'renders edit button');
});
