import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { test } from 'ember-qunit';
import { assign } from 'ember-platform';
import hbs from 'htmlbars-inline-precompile';
import wait from 'ember-test-helpers/wait';


moduleForComponent('channel-redesign/metadata-box/commerce-metadata', {
  beforeEach() {
    this.set('isFlEnabled', true);
    this.set('isFlDetailsLinkEnabled', true);
  }
});

function setupChannel(context, options = {}) {
  context.set('channel', assign(options, {
    views: 456
  }));
}

test('renders details link if partner is streaming fuel game', function(assert) {
  assert.expect(3);
  let requestCalls = [];

  setupChannel(this, {
    partner: true,
    game: 'League of Legends'
  });

  this.server.get('http://api.twitch.tv/kraken/games/:game_name/settings', (schema, request) => {
    requestCalls.push(request);
    return {details_enabled: true};
  });
  this.render(hbs`{{channel-redesign/metadata-box/commerce-metadata channel=channel}}`);

  return wait().then(() => {
    assert.equal(requestCalls.length, 1, 'The api service is called once');
    assert.equal(this.$('a').text().trim(), 'Get this game', 'renders game details link');
    assert.equal(this.$('span').text(), '|', 'renders pipe');
  });
});

test('renders "Game Details" link if partner is streaming Streamline', function(assert) {
  assert.expect(3);
  let requestCalls = [];

  setupChannel(this, {
    partner: true,
    game: 'Streamline'
  });

  this.server.get('http://api.twitch.tv/kraken/games/:game_name/settings', (schema, request) => {
    requestCalls.push(request);
    return {details_enabled: true};
  });
  this.render(hbs`{{channel-redesign/metadata-box/commerce-metadata channel=channel}}`);

  return wait().then(() => {
    assert.equal(requestCalls.length, 1, 'The api service is called once');
    assert.equal(this.$('a').text().trim(), 'Game Details', 'renders game details link');
    assert.equal(this.$('span').text(), '|', 'renders pipe');
  });
});

test('does not render link on channels playing non-fuel games', function(assert) {
  assert.expect(3);
  let requestCalls = [];

  setupChannel(this, {
    partner: true,
    game: 'League of Legends'
  });

  this.server.get('http://api.twitch.tv/kraken/games/:game_name/settings', (schema, request) => {
    requestCalls.push(request);
    return {details_enabled: false};
  });
  this.render(hbs`{{channel-redesign/metadata-box/commerce-metadata channel=channel}}`);

  return wait().then(() => {
    assert.equal(requestCalls.length, 1, 'calls the api service once');
    assert.equal(this.$('a').text(), '', 'does not render game details link');
    assert.equal(this.$('span').text(), '', 'does not render pipe');
  });
});

test('does not make api call on non-partner channels', function(assert) {
  assert.expect(3);
  let requestCalls = [];

  setupChannel(this, {
    partner: false,
    game: 'Streamline'
  });

  this.server.get('http://api.twitch.tv/kraken/games/:game_name/settings', (schema, request) => {
    requestCalls.push(request);
    return {details_enabled: true};
  });
  this.render(hbs`{{channel-redesign/metadata-box/commerce-metadata channel=channel}}`);

  return wait().then(() => {
    assert.equal(requestCalls.length, 0, 'does not call the api service');
    assert.equal(this.$('a').text(), '', 'renders game details link');
    assert.equal(this.$('span').text(), '', 'renders pipe');
  });
});
