import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { skip } from 'ember-qunit';
import wait from 'ember-test-helpers/wait';
import hbs from 'htmlbars-inline-precompile';
import { FakeExperimentService } from 'web-client/tests/helpers/experiment-group-test';
import { test } from 'ember-qunit';

function setupChannel(context, options = {}) {
  context.set('channel', {
    id: 'twitch',
    name: 'twitch',
    displayName: 'Twitch',
    videos: { load() {}, total: 12 },
    followingTotal: 3,
    followersTotal: 6,
    isSubscribed: options.isSubscribed,
    product: options.product
  });
}

moduleForComponent('channel-redesign/top-bar', {
  beforeEach() {
    this.on('modal', () => this);
    this.on('scrollForUser', () => this);
    this.on('toggleEditingMode', () => this);
  }
});

skip('component must receive a channel', function(assert) {
  assert.throws(() => {
    this.render(hbs`{{channel-redesign/top-bar}}`);
  }, /top-bar component requires channel argument/);
});

skip('renders channel', function(assert) {
  setupChannel(this);
  this.render(hbs`
    {{channel-redesign/top-bar
      channel=channel
      openInModal=(action 'modal')
      closeModal=(action 'modal')
      scrollForUser=(action 'scrollForUser')
    }}`);

  assert.elementText('.cn-bar__displayname', 'Twitch', 'shows display name');
  assert.elementText('.cn-bar .js-cn-tabs__videos', /Videos\s+12/, 'shows videos count');
  assert.elementText('.cn-bar .js-cn-tabs__followers', /Followers\s+6/, 'shows followers count');
  assert.elementText('.cn-bar .js-cn-tabs__following', /Following\s+3/, 'shows following count');
  assert.equal(this.$('.cn-bar .cn-tabs__button .follow-button').length, 1, 'renders follow button');
  assert.equal(this.$('.cn-bar .cn-tabs__button .js-sub-button').length, 0, 'does not render subscribe button');
  assert.equal(this.$('.cn-bar .cn-tabs__button .cn-button-edit').length, 0, 'does not render edit button');
  assert.equal(this.$('.cn-bar .cn-tabs__profile .cn-livestatus__circle').length, 0, 'does not render live status circle');
});

skip('renders edit button if `canEditBanner` is `true`', function(assert) {
  setupChannel(this);

  this.render(hbs`
    {{channel-redesign/top-bar
      channel=channel
      openInModal=(action 'modal')
      closeModal=(action 'modal')
      scrollForUser=(action 'scrollForUser')
      toggleEditingMode=(action 'toggleEditingMode')
      canEditBanner=true
    }}`);

  assert.equal(this.$('.cn-bar .cn-tabs__button .cn-button-edit').length, 1, 'renders edit button');
});

test('renders support button when channel is part of adopt experiment', function(assert) {
  setupChannel(this);
  this.owner.register('service:experiments', FakeExperimentService);
  this.owner.lookup('service:experiments').use({ ADOPT: 'yes' });

  this.render(hbs`
    {{channel-redesign/top-bar
      channel=channel
    }}`);

  assert.equal(this.$('.cn-bar .cn-tabs__button .support-button').length, 1, 'renders support button');
});

test('does not render support button when channel is not part of adopt experiment', function(assert) {
  setupChannel(this);
  this.owner.register('service:experiments', FakeExperimentService);
  this.owner.lookup('service:experiments').use({ ADOPT: 'no' });

  this.render(hbs`
    {{channel-redesign/top-bar
      channel=channel
    }}`);

  assert.equal(this.$('.cn-bar .cn-tabs__button .support-button').length, 0, 'does not renders support button');
});

skip('renders subscribe button when channel can be subscribed to', function(assert) {
  assert.expect(1);

  setupChannel(this, {
    isSubscribed: {
      isSubscribed: false,
      isLoading: false,
      isLoaded: true
    },
    product: {
      price: "4.99",
      isLoaded: true
    }
  });

  this.render(hbs`
    {{channel-redesign/top-bar
      channel=channel
      openInModal=(action 'modal')
      closeModal=(action 'modal')
      scrollForUser=(action 'scrollForUser')
    }}`);

  return wait().then(() => {
    assert.equal(this.$('.cn-bar .cn-tabs__button .js-sub-button').length, 1, 'renders subscribe button');
  });
});


skip('renders live indicator if `isLive` is `true`', function(assert) {
  setupChannel(this);

  this.render(hbs`
    {{channel-redesign/top-bar
      channel=channel
      openInModal=(action 'modal')
      closeModal=(action 'modal')
      scrollForUser=(action 'scrollForUser')
      toggleEditingMode=(action 'toggleEditingMode')
      isLive=true
    }}`);
  assert.equal(this.$('.cn-bar .cn-tabs__profile .cn-livestatus__circle').length, 1, 'renders live status circle');
});
