import { moduleForComponent, test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';

moduleForComponent('channel-split', {
  integration: true
});

test('it calculates pane widths', function(assert) {
  this.render(hbs`
    <div style="width: 860px;">
      {{#channel-split gridUnit=400 divider=60 panelGutter=10 as |split flex chunk|}}
        {{#split-pane width=flex}}{{/split-pane}}
        {{#split-pane width=chunk}}{{/split-pane}}
      {{/channel-split}}
    </div>
  `);
  assert.elementWidth('.split-pane:first', 400);
  assert.elementWidth('.split-pane:last', 400);

  this.render(hbs`
    <div style="width: 1200px;">
      {{#channel-split gridUnit=200 divider=50 panelGutter=30 as |split flex chunk|}}
        {{#split-pane width=flex}}{{/split-pane}}
        {{#split-pane width=chunk}}{{/split-pane}}
      {{/channel-split}}
    </div>
  `);
  assert.elementWidth('.split-pane:first', 260);
  assert.elementWidth('.split-pane:last', 890);
});
