import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import hbs from 'htmlbars-inline-precompile';
import { stubLogin } from 'web-client/tests/helpers/stub-login';
import { AuthenticatedSession } from 'web-client/tests/helpers/mock-session-service';
import { test } from 'ember-qunit';
import wait from 'ember-test-helpers/wait';
import moment from 'moment';
import RSVP from 'rsvp';
import Service from 'ember-service';

const PlatformStub = {
  id: 'hirez',
  message: 'Link your accounts and watch SMITE Super Regionals Nov. 16-20, and you could win FREE Rolls for the Regular Season and Odyssey 2017 Chests!',
  startTime: '2016-11-16T00:00:00-05:00',
  endTime: '2016-11-20T23:50:00-05:00',
  channels: [
    'hireztv'
  ]
};

const LinkedUserVhsStub = Service.extend({
  getPlatformForChannel() {
    return PlatformStub;
  },
  isCurrentUserLinkedToPlatform() {
    return RSVP.resolve(true);
  }
});

const UnlinkedUserVhsStub = Service.extend({
  getPlatformForChannel() {
    return PlatformStub;
  },
  isCurrentUserLinkedToPlatform() {
    return RSVP.resolve(false);
  }
});

function asLoggedInUser(testModule) {
  testModule.register('service:session', AuthenticatedSession);
  stubLogin();
}

moduleForComponent('channel-upsell-banner', 'Integration | Component | channel upsell banner', {
  integration: true,
  beforeEach() {
    this.register('service:vhs', UnlinkedUserVhsStub);
  }
});

test('Should see follow upsell if user is logged out', function(assert) {
  assert.expect(4);

  this.set('isLiveStatusReady', true);
  this.set('isLive', true);
  this.set('name', "cohhcarnage");
  this.set('isChannelLinked', false);
  this.set('currentTime', moment.parseZone('2016-11-18T00:00:00-05:00'));

  let done = assert.async();

  this.render(hbs`
    {{channel-upsell-banner
      isLiveStatusReady=isLiveStatusReady
      isLive=isLive
      isChannelLinked=isChannelLinked
      currentTime=currentTime
      name=name
    }}
  `);

  wait().then(() => {
    assert.elementText(this.$('h4'), 'Enjoying the show?', 'Should have follow CTA header');
    assert.elementText(this.$('p'), 'Log in to follow this channel and get notifications when it goes live!', 'Should have follow CTA text');
    assert.elementText(this.$('.button:eq(0)'), 'Log In', 'Should have Log In button');
    assert.elementText(this.$('.button:eq(1)'), "Don't have an account? Sign up", 'Should have sign up button');

    done();
  });
});

test('Should see CTA box if a live channel is run by a supported platform', function (assert) {
  assert.expect(3);
  asLoggedInUser(this);

  this.set('isLiveStatusReady', true);
  this.set('isLive', true);
  this.set('name', "hireztv");
  this.set('isChannelLinked', true);
  this.set('currentTime', moment.parseZone('2016-11-18T00:00:00-05:00'));

  let done = assert.async();

  this.render(hbs`
    {{channel-upsell-banner
      isLiveStatusReady=isLiveStatusReady
      isLive=isLive
      isChannelLinked=isChannelLinked
      currentTime=currentTime
      name=name
    }}
  `);

  wait().then(() => {
    assert.elementText(this.$('h4'), 'Drops are available', 'Should have drops message');
    assert.elementText(this.$('p'), 'Link your accounts and watch SMITE Super Regionals Nov. 16-20, and you could win FREE Rolls for the Regular Season and Odyssey 2017 Chests!', 'Should have link detail');
    assert.elementText(this.$('.button'), 'Link Now', 'Should have link message');

    done();
  });
});

test('Should not see CTA box if not live', function (assert) {
  assert.expect(3);
  asLoggedInUser(this);

  this.set('isLiveStatusReady', true);
  this.set('isLive', false);
  this.set('name', "hireztv");
  this.set('isChannelLinked', true);
  this.set('currentTime', moment.parseZone('2016-11-18T00:00:00-05:00'));

  let done = assert.async();

  this.render(hbs`
    {{channel-upsell-banner
      isLiveStatusReady=isLiveStatusReady
      isLive=isLive
      isChannelLinked=isChannelLinked
      currentTime=currentTime
      name=name
    }}
  `);

  wait().then(() => {
    assert.notOk(this.$('h4').length);
    assert.notOk(this.$('p').length);
    assert.notOk(this.$('.button').length);

    done();
  });
});

test('CTA box is dismissed when clicking the dismiss button', function (assert) {
  assert.expect(2);
  asLoggedInUser(this);

  this.set('isLiveStatusReady', true);
  this.set('isLive', true);
  this.set('name', "hireztv");
  this.set('isChannelLinked', true);
  this.set('currentTime', moment.parseZone('2016-11-18T00:00:00-05:00'));

  let done = assert.async();

  this.render(hbs`
    {{channel-upsell-banner
      isLiveStatusReady=isLiveStatusReady
      isLive=isLive
      isChannelLinked=isChannelLinked
      currentTime=currentTime
      name=name
    }}
  `);

  wait().then(() => {
    assert.ok(this.$('.js-upsell-banner').is(':visible'), 'CTA box starts visible');

    this.$('.js-close-button').click();

    assert.ok(this.$('.js-upsell-banner').is(':hidden'), 'CTA box was hidden when dismissing the banner');

    done();
  });
});

test('Should not see CTA box if outside of time range', function (assert) {
  assert.expect(3);
  asLoggedInUser(this);

  this.set('isLiveStatusReady', true);
  this.set('isLive', true);
  this.set('name', "hireztv");
  this.set('isChannelLinked', true);
  this.set('currentTime', moment.parseZone('2016-01-01T00:00:00-05:00'));

  let done = assert.async();

  this.render(hbs`
    {{channel-upsell-banner
      isLiveStatusReady=isLiveStatusReady
      isLive=isLive
      isChannelLinked=isChannelLinked
      currentTime=currentTime
      name=name
    }}
  `);

  wait().then(() => {
    assert.notOk(this.$('h4').length);
    assert.notOk(this.$('p').length);
    assert.notOk(this.$('.button').length);

    done();
  });
});

moduleForComponent('channel-upsell-banner', 'Integration | Component | channel upsell banner linked', {
  integration: true,
  beforeEach() {
    this.register('service:vhs', LinkedUserVhsStub);
    this.register('service:session', AuthenticatedSession);
    stubLogin();
  }
});

test('Should not see CTA box if already linked', function (assert) {
  assert.expect(3);

  this.set('isLiveStatusReady', true);
  this.set('isLive', true);
  this.set('name', "hireztv");
  this.set('isChannelLinked', true);
  this.set('currentTime', moment.parseZone('2016-11-18T00:00:00-05:00'));

  let done = assert.async();

  this.render(hbs`
    {{channel-upsell-banner
      isLiveStatusReady=isLiveStatusReady
      isLive=isLive
      name=name
      isChannelLinked=isChannelLinked
      currentTime=currentTime
    }}
  `);

  wait().then(() => {
    assert.notOk(this.$('h4').length);
    assert.notOk(this.$('p').length);
    assert.notOk(this.$('.button').length);

    done();
  });
});
