import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';

moduleForComponent('channel-wrapper');

test('it renders outlet or error message', function(assert) {
  assert.expect(7);

  this.set('model', {
    notFound: false,
    unavailable: false,
    nonGaming: false
  });

  this.render(hbs`
    {{#channel-wrapper model=model}}
      template block text
    {{/channel-wrapper}}
  `);

  assert.equal(this.$().text().trim(), 'template block text');

  ['notFound', 'unavailable', 'nonGaming'].forEach(prop => {
    this.set(`model.${prop}`, true);

    let text = this.$().text().trim();

    assert.notStringIncludes(text, 'template block text', `outlet not rendered on ${prop} error.`);
    assert.stringIncludes(text, 'Browse Other Channels', `user-error component rendered on ${prop} error.`);

    this.set(`model.${prop}`, false);
  });
});
