import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import jQuery from 'jquery';
import { test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';

moduleForComponent('channels-platform-selector', {
  beforeEach() {
    this.isShowingDropdown = () => {
      return this.$('.js-platform-dropdown').length === 1;
    };
  }
});

test('it is hidden when streamType is `random`', function (assert) {
  this.render(hbs`{{channels-platform-selector streamType="random"}}`);

  assert.equal(this.$('#filter-contain').length, 0);
});

test('does not show platform list initially', function (assert) {
  this.render(hbs`{{channels-platform-selector streamType="top"}}`);

  assert.notOk(this.isShowingDropdown());
});

test('shows the platform list when clicked', function (assert) {
  this.render(hbs`{{channels-platform-selector streamType="top"}}`);

  this.$('.filter-toggle').click();

  assert.ok(this.isShowingDropdown());
});

test('can toggle back and forth by clicking drop down title', function (assert) {
  this.render(hbs`{{channels-platform-selector streamType="top"}}`);

  this.$('.filter-toggle').click();

  assert.ok(this.isShowingDropdown());

  this.$('.filter-toggle').click();

  assert.notOk(this.isShowingDropdown());

  this.$('.filter-toggle').click();

  assert.ok(this.isShowingDropdown());

  this.$('.filter-toggle').click();

  assert.notOk(this.isShowingDropdown());
});

test('clicking outside the drop down closes it', function (assert) {
  this.render(hbs`{{channels-platform-selector streamType="top"}}`);

  this.$('.filter-toggle').click();

  assert.ok(this.isShowingDropdown(), 'precond - dropdown shown initially');

  jQuery('#qunit-fixture').click();

  assert.notOk(this.isShowingDropdown());
});
