import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';

let passthroughActions = [
  'focusChatInputWindow',
  'sendMessage',
  'selectEmoticon',
  'toggleEmoticonSelector',
  'toggleViewerList',
  'hideChat',
  'popoutChat'
];

moduleForComponent('chat/chat-interface', 'Integration | Component | chat/chat interface', {
  beforeEach(assert) {
    passthroughActions.forEach((action) => {
      this.on(action, function () {
        assert.ok(true, `${action} action triggered`);
      });
    });
  }
});

test('it renders', function (assert) {
  assert.expect(3); // Note: We use `expect` here because of the many action assertions set up in beforeEach

  this.render(hbs`{{chat/chat-interface
    hideChat=(action 'hideChat')
    popoutChat=(action 'popoutChat')
    sendMessage=(action 'sendMessage')
    toggleViewerList=(action 'toggleViewerList')
    focusChatInputWindow=(action 'focusChatInputWindow')
    toggleEmoticonSelector=(action 'toggleEmoticonSelector')
  }}`);

  assert.equal(this.$('.js-chat-buttons').length, 1, 'renders chat buttons container');
  assert.equal(this.$('.js-chat-settings-menu').length, 1, 'renders chat settings menu');
  assert.equal(this.$('.js-emoticon-selector').length, 0, 'does not render emoticon selector');
});

test('show emoticon selector', function (assert) {
  assert.expect(1);

  this.render(hbs`{{chat/chat-interface
    showEmoticonSelector=true
    hideChat=(action 'hideChat')
    popoutChat=(action 'popoutChat')
    sendMessage=(action 'sendMessage')
    toggleViewerList=(action 'toggleViewerList')
    focusChatInputWindow=(action 'focusChatInputWindow')
    toggleEmoticonSelector=(action 'toggleEmoticonSelector')
  }}`);

  assert.equal(this.$('.js-emoticon-selector').length, 1, 'renders emoticon selector');
});

test('room model loading', function (assert) {
  assert.expect(2);

  this.render(hbs`{{chat/chat-interface
    showEmoticonSelector=true
    isRoomModelLoading=true
    hideChat=(action 'hideChat')
    popoutChat=(action 'popoutChat')
    sendMessage=(action 'sendMessage')
    toggleViewerList=(action 'toggleViewerList')
    focusChatInputWindow=(action 'focusChatInputWindow')
    toggleEmoticonSelector=(action 'toggleEmoticonSelector')
  }}`);

  assert.equal(this.$('.js-emoticon-selector').length, 0, 'does not render emoticon selector');
  assert.equal(this.$('.js-chat-settings-menu').length, 0, 'does not render emoticon selector');
});
