import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { skip, test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';

let passthroughActions = [
  'toggleEmoticonSelector',
  'hideChat',
  'popoutChat'
];

moduleForComponent('chat/chat-room', 'Integration | Component | chat/chat room', {
  beforeEach(assert) {
    passthroughActions.forEach((action) => {
      this.on(action, function () {
        assert.ok(true, `${action} action triggered`);
      });
    });
  }
});

test('it renders', function (assert) {
  assert.expect(13); // Note: We use `expect` here because of the many action assertions set up in beforeEach

  this.render(hbs`{{chat/chat-room
    toggleEmoticonSelector=(action 'toggleEmoticonSelector')
    hideChat=(action 'hideChat')
    popoutChat=(action 'popoutChat')
  }}`);

  assert.equal(this.$('.js-chat-messages').length, 1, 'renders chat');
  assert.equal(this.$('.js-chat-interface').length, 1, 'renders chat helpers');
  assert.equal(this.$('.js-chat-viewers').length, 0, 'does not render chat viewer list');
  assert.equal(this.$('.js-moderation-card').length, 0, 'does not render moderation card');
  assert.equal(this.$('.js-resub-notification').length, 0, 'does not render resub notification');
  assert.equal(this.$('.js-host-mode-notification').length, 0, 'does not render host mode notification');
  assert.equal(this.$('.js-blc-notification').length, 0, 'does not render blc notification');
  assert.equal(this.$('.js-nb-notification').length, 0, 'does not render native broadcast notification');
  assert.equal(this.$('.js-vp-notification').length, 0, 'does not render viewing party notification');
  assert.equal(this.$('.js-alt-role-notification').length, 0, 'does not render alt role notification');
  assert.equal(this.$('.js-display-name-notification').length, 0, 'does not render display name notification');
  assert.equal(this.$('.js-chat-rules').length, 0, 'does not render chat rules');
  assert.equal(this.$('.js-chat-more-messages').length, 0, 'does not render more messages');
});

test('moderation card', function (assert) {
  assert.expect(1);

  this.render(hbs`{{chat/chat-room
    showModerationCard=true
    
    toggleEmoticonSelector=(action 'toggleEmoticonSelector')
    hideChat=(action 'hideChat')
    popoutChat=(action 'popoutChat')
  }}`);

  assert.equal(this.$('.js-moderation-card').length, 1, 'renders moderation card');
});

test('native broadcast notification', function (assert) {
  assert.expect(1);

  this.render(hbs`{{chat/chat-room
    showNBNotification=true
    
    toggleEmoticonSelector=(action 'toggleEmoticonSelector')
    hideChat=(action 'hideChat')
    popoutChat=(action 'popoutChat')
  }}`);

  assert.equal(this.$('.js-nb-notification').length, 1, 'renders native broadcast notification');
});

test('viewing party notification', function (assert) {
  assert.expect(1);

  this.render(hbs`{{chat/chat-room
    showVPNotification=true
    
    toggleEmoticonSelector=(action 'toggleEmoticonSelector')
    hideChat=(action 'hideChat')
    popoutChat=(action 'popoutChat')
  }}`);

  assert.equal(this.$('.js-vp-notification').length, 1, 'renders viewing party notification');
});

test('alt role notification', function (assert) {
  assert.expect(1);

  this.render(hbs`{{chat/chat-room
    showARNotification=true
    
    toggleEmoticonSelector=(action 'toggleEmoticonSelector')
    hideChat=(action 'hideChat')
    popoutChat=(action 'popoutChat')
  }}`);

  assert.equal(this.$('.js-alt-role-notification').length, 1, 'renders alt role notification');
});

test('display name notification', function (assert) {
  assert.expect(1);

  this.render(hbs`{{chat/chat-room
    showDisplayNameNotification=true
    
    toggleEmoticonSelector=(action 'toggleEmoticonSelector')
    hideChat=(action 'hideChat')
    popoutChat=(action 'popoutChat')
  }}`);

  assert.equal(this.$('.js-display-name-notification').length, 1, 'renders display name notification');
});

skip('blc notification', function (assert) { // TODO: Fix `blc-notification` for test usage
  assert.expect(1);

  this.render(hbs`{{chat/chat-room
    showBLCNotification=true
    
    toggleEmoticonSelector=(action 'toggleEmoticonSelector')
    hideChat=(action 'hideChat')
    popoutChat=(action 'popoutChat')
  }}`);

  assert.equal(this.$('.js-blc-notification').length, 1, 'renders blc notification');
});

skip('viewer list', function (assert) { // TODO: Fix `twitch-chat-viewers` for test usage
  this.render(hbs`{{chat/chat-room
    showViewerList=true
    
    toggleEmoticonSelector=(action 'toggleEmoticonSelector')
    hideChat=(action 'hideChat')
    popoutChat=(action 'popoutChat')
  }}`);

  assert.equal(this.$('.js-chat-viewers').length, 1, 'renders chat viewer list');
});
