import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';
import { COLOR_OPTIONS } from 'web-client/models/settings';
import { AuthenticatedSession } from 'web-client/tests/helpers/mock-session-service';

let color;

moduleForComponent('chat/chat-settings-menu', 'Integration | Component | chat/chat settings menu', {
  beforeEach(assert) {
    this.set('user', {
      channel: 'twitch',
      chatBadges: [],
      chatColor: COLOR_OPTIONS[0],
      isModeratorOrHigher: false,
      isOwner: false,
      isBroadcaster: false,
      isTwitchPrivilegedUser: false,
      publicInvitesEnabled: false
    });

    this.on('setColor', function (actual) {
      assert.equal(actual, color, 'correct color passed');
    });

    this.on('clearChat', function() {});
  }
});

test('logged out user', function (assert) {
  this.render(hbs`{{chat/chat-settings-menu chatUser=user setColor=(action 'setColor') clearChat=(action 'clearChat')}}`);

  assert.equal(this.$('.js-chat-display').length, 1, 'renders display settings');
  assert.equal(this.$('.js-chat-settings').length, 1, 'renders chat settings');
  assert.equal(this.$('.js-chat-appearance').length, 0, 'does not render chat appearance settings for logged out users');
});

test('logged in user', function (assert) {
  this.register('service:session', AuthenticatedSession);

  this.render(hbs`{{chat/chat-settings-menu chatUser=user setColor=(action 'setColor') clearChat=(action 'clearChat')}}`);

  let chatAppearance = this.$('.js-chat-appearance');
  assert.equal(chatAppearance.length, 1, 'renders chat appearance settings if logged in');
  assert.ok(chatAppearance.hasClass('hidden'), 'appearance settings are hidden by default');
  assert.equal(this.$('.js-moderation').length, 0, 'moderator settings not shown');
});

test('toggle appearance settings', function (assert) {
  this.register('service:session', AuthenticatedSession);

  this.render(hbs`{{chat/chat-settings-menu chatUser=user setColor=(action 'setColor') clearChat=(action 'clearChat')}}`);

  this.$('.js-edit-chat-appearance button').click();

  let toggle = this.$('.js-edit-chat-appearance');
  let chatAppearance = this.$('.js-chat-appearance');
  let settings = this.$('.js-chat-settings');
  let selectors = this.$('.js-chat-appearance-selectors');

  assert.notOk(chatAppearance.hasClass('hidden'), 'appearance settings are shown');
  assert.notOk(selectors.hasClass('hidden'), 'appearance selectors are shown');
  assert.ok(toggle.hasClass('hidden'), 'edit button is hidden');
  assert.ok(settings.hasClass('hidden'), 'settings are hidden');
});

test('chat settings - moderator', function (assert) {
  this.set('user.isModeratorOrHigher', true);

  this.render(hbs`{{chat/chat-settings-menu chatUser=user setColor=(action 'setColor') clearChat=(action 'clearChat')}}`);

  assert.equal(this.$('.js-moderation').length, 1, 'moderator settings shown');
  assert.equal(this.$('.js-mod-icons-checkbox').length, 1, 'mod icons checkbox shown');
  assert.equal(this.$('.js-slow-mode-checkbox').length, 1, 'slow mode checkbox shown');
  assert.equal(this.$('.js-clear-chat').length, 1, 'clear chat button shown');
  assert.equal(this.$('.js-public-invites-checkbox').length, 0, 'public invites checkbox not shown');
  assert.equal(this.$('.js-mod-actions-checkbox').length, 0, 'mod actions checkbox not shown');
  assert.equal(this.$('.js-message-flags-checkbox').length, 0, 'message flags checkbox not shown');
});

test('chat settings - owner', function (assert) {
  this.set('user.isModeratorOrHigher', true);
  this.set('user.isOwner', true);

  this.render(hbs`{{chat/chat-settings-menu chatUser=user setColor=(action 'setColor') clearChat=(action 'clearChat')}}`);

  assert.equal(this.$('.js-moderation').length, 1, 'moderator settings shown');
  assert.equal(this.$('.js-public-invites-checkbox').length, 1, 'public invites checkbox shown');
  assert.equal(this.$('.js-mod-actions-checkbox').length, 0, 'mod actions checkbox not shown');
  assert.equal(this.$('.js-message-flags-checkbox').length, 0, 'message flags checkbox not shown');
});

test('chat settings - mod/broadcaster', function (assert) {
  this.set('user.isModeratorOrHigher', true);
  this.set('user.isModeratorOrBroadcaster', true);

  this.render(hbs`{{chat/chat-settings-menu chatUser=user setColor=(action 'setColor') clearChat=(action 'clearChat')}}`);

  assert.equal(this.$('.js-moderation').length, 1, 'moderator settings shown');
  assert.equal(this.$('.js-public-invites-checkbox').length, 0, 'public invites checkbox not shown');
  assert.equal(this.$('.js-mod-actions-checkbox').length, 1, 'mod actions checkbox shown');
  assert.equal(this.$('.js-message-flags-checkbox').length, 0, 'message flags checkbox not shown');
});

test('chat settings - privileged user', function (assert) {
  this.set('user.isModeratorOrHigher', true);
  this.set('user.isTwitchPrivilegedUser', true);

  this.render(hbs`{{chat/chat-settings-menu chatUser=user setColor=(action 'setColor') clearChat=(action 'clearChat')}}`);

  assert.equal(this.$('.js-moderation').length, 1, 'moderator settings shown');
  assert.equal(this.$('.js-public-invites-checkbox').length, 0, 'public invites checkbox not shown');
  assert.equal(this.$('.js-mod-actions-checkbox').length, 0, 'mod actions checkbox not shown');
  assert.equal(this.$('.js-message-flags-checkbox').length, 1, 'message flags checkbox shown');
});
