import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';
import Service from 'ember-service';

let passthroughActions = [
  'focusChatInputWindow',
  'sendMessage',
  'toggleEmoticonSelector'
];

moduleForComponent('chat/chat-textarea', 'Integration | Component | chat/chat textarea', {
  beforeEach(assert) {
    passthroughActions.forEach((action) => {
      this.on(action, function () {
        assert.ok(true, `${action} action triggered`);
      });
    });
  }
});

test('it renders', function (assert) {
  assert.expect(3); // Note: We use `expect` here because of the many action assertions set up in beforeEach

  this.render(hbs`{{chat/chat-textarea
    focusChatInputWindow=(action 'focusChatInputWindow')
    sendMessage=(action 'sendMessage')
  }}`);

  assert.equal(this.$('.js-chat-input').length, 1, 'renders chat input');
  assert.equal(this.$('.js-emoticon-toggle').length, 0, 'does not render emoticon selector');
  assert.equal(this.$('.js-bits-toggle').length, 0, 'does not render bits toggle');
});

test('emoticon toggle', function (assert) {
  assert.expect(1);

  this.render(hbs`{{chat/chat-textarea
    showEmoticonSelectorToggle=true
    focusChatInputWindow=(action 'focusChatInputWindow')
    toggleEmoticonSelector=(action 'toggleEmoticonSelector')
    sendMessage=(action 'sendMessage')
  }}`);

  assert.equal(this.$('.js-emoticon-toggle').length, 1, 'renders emoticon toggle');
});

test('bits toggle', function (assert) {
  this.owner.register('service:bits-room', Service.extend({
    isHelperShown: true
  }));
  this.render(hbs`{{chat/chat-textarea
    focusChatInputWindow=(action 'focusChatInputWindow')
    sendMessage=(action 'sendMessage')
  }}`);

  assert.equal(this.$('.js-bits-toggle').length, 1, 'renders bits toggle');
});
