import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';

moduleForComponent('chat/host-mode-notification', 'Integration | Component | chat/host mode notification');

test('text and close action', function (assert) {
  assert.expect(3);

  this.hostModeTargetName = 'bighead1g';
  this.on('close', () => {
    assert.ok(true, 'close action triggered');
  });
  this.render(hbs`
    {{chat/host-mode-notification
      hostModeTargetName=hostModeTargetName
      close=(action 'close')}}
  `);

  assert.elementText('.header', `Hosting ${this.hostModeTargetName}`, 'Header text');
  assert.elementText('.button', 'Go to Channel', 'Button text');
  this.$().find('.close-button').click();
});
