import { moduleForComponent, test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';
import RSVP from 'rsvp';
import { helper } from 'ember-helper';
import ChannelPage from 'web-client/tests/pages/channel';
import { SHARE_MESSAGE_CHARACTER_LIMIT } from 'web-client/components/chat/resub-notification/component';
import config from 'web-client/config/environment';

const CHANNEL_NAME = 'Twitch';
const RESUB_NOTIFICATION = { token_id: 9000, token_month: 12 }; // eslint-disable-line camelcase
const SHARE_MESSAGE = 'custom message!';

moduleForComponent('chat/resub-notification', 'Integration | Component | resub notification', {
  integration: true,

  setup() {
    this.register('helper:i18n', helper(([value]) => value));
    this.container.lookup('service:intl').setLocale(config.i18n.baseLocale);

    this.set('channelName', CHANNEL_NAME);
    this.set('resubNotification', RESUB_NOTIFICATION);
    this.on('postResubMessage', () => {});
    this.on('closeResubNotification', () => {});

    this.page = ChannelPage.create();
  },

  renderComponent() {
    this.render(hbs`
      {{chat/resub-notification
        channelName=channelName
        resubNotification=resubNotification
        closeResubNotification=(action 'closeResubNotification')
        postResubMessage=(action 'postResubMessage')}}
    `);
  }
});

test('it renders, unhides notification balloon, closes balloon, and closes completely', function (assert) {
  assert.expect(14);

  this.on('closeResubNotification', () => {
    assert.ok(true, 'passed-in closeResubNotification action is invoked');
  });

  this.renderComponent();

  assert.notOk(
    this.$(this.page.resubStickyMessage).hasClass(this.page.resubStickyMessageHiddenClass),
    'resub message is NOT hidden'
  );

  assert.equal(
    this.$(this.page.resubMessage).text().trim(),
    `It's your ${ RESUB_NOTIFICATION.token_month } month anniversary!`,
    'resub notification is displayed'
  );

  assert.equal(this.$(this.page.resubFirstShareButton).text().trim(), 'Share', 'button has "Share" text');
  assert.ok(this.$(this.page.resubWrap).hasClass(this.page.resubWrapHiddenClass), 'resub wrap is hidden');
  assert.notOk(this.$(this.page.resubNotif).hasClass(this.page.resubNotifShownClass), 'notification balloon is NOT shown');
  assert.ok(this.$(this.page.resubNotif).hasClass(this.page.resubNotifHiddenClass), 'notification balloon is hidden');

  this.$(this.page.resubFirstShareButton).click();

  assert.notOk(this.$(this.page.resubWrap).hasClass(this.page.resubWrapHiddenClass), 'resub wrap is NOT hidden');
  assert.ok(this.$(this.page.resubNotif).hasClass(this.page.resubNotifShownClass), 'notification balloon is shown');
  assert.notOk(this.$(this.page.resubNotif).hasClass(this.page.resubNotifHiddenClass), 'notification balloon is NOT hidden');

  assert.equal(
    this.$(this.page.resubNotifInput).attr('placeholder'),
    'Add a message to the streamer',
    'input placeholder is present'
  );

  assert.equal(
    this.$(this.page.resubNotifParagraph).html(),
    `Hooray! Let <span class="strong">${ CHANNEL_NAME }</span> know it's your ${ RESUB_NOTIFICATION.token_month } month anniversary.`,
    'detailed resub notification notice is displayed and stylized'
  );

  this.$(this.page.resubSecondCloseButton).click();

  assert.notOk(this.$(this.page.resubNotif).hasClass(this.page.resubNotifShownClass), 'notification balloon is NOT shown');
  assert.ok(this.$(this.page.resubNotif).hasClass(this.page.resubNotifHiddenClass), 'notification balloon is hidden');

  this.$(this.page.resubFirstCloseButton).click();
});

test(`when message is over ${ SHARE_MESSAGE_CHARACTER_LIMIT } characters, "Share" button is disabled and replaced with number of characters over limit`, function (assert) {
  assert.expect(5);

  let overLimitMessage = new Array(30).join(SHARE_MESSAGE);

  this.renderComponent();

  assert.notOk(this.$(this.page.resubSecondShareButton).prop('disabled'), '"Share" button is NOT disabled');

  assert.equal(
    this.$(this.page.resubSecondShareButton).text().trim(),
    "Share",
    'second button has "Share" as text'
  );

  this.$(this.page.resubNotifInput).val(overLimitMessage);
  this.$(this.page.resubNotifInput).change();

  assert.ok(this.$(this.page.resubSecondShareButton).prop('disabled'), '"Share" button is disabled');
  assert.ok(this.$(this.page.resubSecondShareButton).hasClass('button--alert'), '"Share" button has alert class');

  assert.equal(
    this.$(this.page.resubSecondShareButton).text().trim(),
    SHARE_MESSAGE_CHARACTER_LIMIT - overLimitMessage.length,
    '"Share" button is replaced with number of characters over limit (negative integer)'
  );
});

test('it shares message and closes notification on second "Share" action', function (assert) {
  assert.expect(4);

  this.on('postResubMessage', (resubTokenId, message) => {
    assert.equal(resubTokenId, RESUB_NOTIFICATION.token_id, 'token ID is passed');
    assert.equal(message, SHARE_MESSAGE, 'share message is passed');

    return RSVP.resolve();
  });

  this.on('closeResubNotification', () => {
    assert.ok(true, 'passed-in closeResubNotification action is invoked');
  });

  this.renderComponent();

  assert.notOk(
    this.$(this.page.resubStickyMessage).hasClass(this.page.resubStickyMessageHiddenClass),
    'resub message is NOT hidden'
  );

  this.$(this.page.resubNotifInput).val(SHARE_MESSAGE);
  this.$(this.page.resubNotifInput).change();
  this.$(this.page.resubSecondShareButton).click();
});
