import { test } from 'ember-qunit';
import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import hbs from 'htmlbars-inline-precompile';
import sinon from 'sinon';
import * as utils from 'ember-metal/utils';
import { BASE_URL } from 'web-client/components/game-art';
import { clipModel } from 'web-client/mirage/fixtures/clips';
import { assign } from 'ember-platform';

moduleForComponent('clips/clips-card-row', 'Integration | Component | clips-card-row', {
  integration: true,
  beforeEach() {
    this.onClipClickSpy = sinon.spy();

    this.set('onClipClick', this.onClipClickSpy);
    this.set('clip', clipModel);
    this.defaultTemplate = hbs`{{clips/clips-card-row clip=clip}}`;
    this.onClipClickTemplate = hbs`{{clips/clips-card-row clip=clip onClipClick=onClipClick}}`;
  }
});

test('renders boxart', function (assert) {
  assert.expect(1);
  this.render(this.defaultTemplate);
  assert.elementCount(`.card__boxpin > img[src='${BASE_URL}/${clipModel.game}-52x72.jpg']`, 1, 'img has game boxart src');

  // Without stubbing/setting up a router, can't test hrefs being set on link-to components
  // assert.elementCount(`.card__boxpin[href='/directory/game${clipModel.game}'`, 1, 'img links to the game directory');
});

test('renders curator information', function (assert) {
  assert.expect(1);

  this.render(this.defaultTemplate);

  assert.elementText('[data-test-selector="clip-row-clip-info"]',
    new RegExp(`Clipped by ${clipModel.curatorDisplayName}`),
    'lists curator'
  );
});

test('thumbnail preview', function (assert) {
  assert.expect(2);
  this.render(this.onClipClickTemplate);

  let thumbnailSelector = `[data-test-selector='clip-row-thumbnail'][src='${clipModel.thumbnail.medium}']`;
  assert.elementCount(thumbnailSelector, 1, 'renders');

  this.$(thumbnailSelector).click();
  assert.ok(this.onClipClickSpy.calledWith(clipModel), 'calls onClipClick on click');
});

test('title', function (assert) {
  assert.expect(2);
  this.render(this.onClipClickTemplate);

  let titleSelector = '[data-test-selector="clip-title-link"]';
  assert.elementText(titleSelector, clipModel.title, 'renders');

  this.$(titleSelector).click();
  assert.ok(this.onClipClickSpy.calledWith(clipModel), 'calls onClipClick on click');
});

test('renders viewcount', function (assert) {
  assert.expect(1);
  this.render(this.defaultTemplate);

  assert.elementText(
    '[data-test-selector="clip-row-clip-info"]',
    new RegExp(`${clipModel.views} plays`),
    'shows viewcount as plays'
  );
});

test('asserts if no clip is passed in', function (assert) {
  sinon.stub(utils, 'assert');

  this.render(hbs`{{clips/clips-card-row}}`);
  assert.equal(utils.assert.getCall(0).args[1], false, 'assert called with false');

  utils.assert.restore();
});

test('when game is empty', function (assert) {
  assert.expect(1);

  this.set('clip', assign({}, clipModel, { game: '' }));
  this.render(this.defaultTemplate);

  assert.elementCount('.card__boxpin', 0, 'does not render boxart');
});
