import { test } from 'ember-qunit';
import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import hbs from 'htmlbars-inline-precompile';
import { clipModel } from 'web-client/mirage/fixtures/clips';

const CLIPS_FIXTURES = [ clipModel ];

const PAGINATOR = {
  items: CLIPS_FIXTURES,
  fetchNextPage() {}
};

moduleForComponent('clips/clips-card-rows', 'Integration | Component | clips-card-rows', {
  integration: true,
  beforeEach() {
    $('#ember-testing').append("<div id='wormhole-overlays'></div>"); // Modal support

    this.set('clips', PAGINATOR);

    // The inner infinite-scroll component expects an element with the `tse-content` class
    this.defaultTemplate = hbs`
      <div class='tse-content'>
        {{clips/clips-card-rows clips=clips}}
      </div>
    `;
  }
});

test('renders clips', function (assert) {
  assert.expect(1);
  this.render(this.defaultTemplate);

  assert.elementCount('[data-test-selector="clips-card-row"]', CLIPS_FIXTURES.length, 'renders a card for each Clip');
});

test('renders modal Clips playback with modal param on click', function (assert) {
  assert.expect(2);

  this.render(this.defaultTemplate);

  let clipUrl = CLIPS_FIXTURES[0].url;
  this.$(`a[href='${clipUrl}']`).click();

  let modalSelector = `[data-test-selector="clips-playback"]`;
  assert.elementCount(modalSelector, 1, 'renders playback modal');

  $('[data-test-selector="modal-container"]').click();
  assert.elementCount(modalSelector, 0, 'closes playback modal on outside click');
});
