import { moduleForComponent, test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';
import Service from 'ember-service';
import RSVP from 'rsvp';
import { NOTLIKETHIS_IMAGE } from 'web-client/components/clips/clips-chat-card/component';
import { assign } from 'ember-platform';
import wait from 'ember-test-helpers/wait';

let clipInfoPromise;
let createdAtDate = new Date().getTime();
let baseResponse = {
  broadcasterDisplayName: 'broadcasterDisplayName',
  broadcasterChannelURL: 'broadcasterChannelURL',
  broadcasterID: 'broadcasterID',
  curatorDisplayName: 'curatorDisplayName',
  curatorChannelURL: 'curatorChannelURL',
  curatorID: 'curatorID',
  previewImage: 'previewImage',
  game: 'game',
  createdAt: createdAtDate,
  title: 'title',
  thumbnails: {
    tiny: 'tiny'
  }
};

const clipsStub = Service.extend({
  getClipInfo(/* channel, slug */) {
    return clipInfoPromise;
  }
});

moduleForComponent('clips/clips-chat-card', 'Integration | Component | clips card', {
  integration: true,
  beforeEach() {
    this.register('service:clips', clipsStub);
    this.set('slug', 'someSlug');
    this.responseMock = assign({}, baseResponse);
    this.defaultTemplate = hbs`{{clips/clips-chat-card slug=slug}}`;
  }
});

test('render a correct link for legacy clips that have channel login name', function(assert) {
  assert.expect(1);

  this.set('slug', 'someChannel/someSlug');
  clipInfoPromise = RSVP.resolve(this.responseMock);
  this.render(this.defaultTemplate);

  assert.equal(this.$('a').attr('href'), 'https://clips.twitch.tv/someChannel/someSlug');
});

test('render when title and slug are valid it shows title', function(assert) {
  assert.expect(3);

  clipInfoPromise = RSVP.resolve(this.responseMock);
  this.render(this.defaultTemplate);

  assert.equal(this.$('.card__title').text().trim(), baseResponse.title);
  assert.equal(this.$('a').attr('href'), 'https://clips.twitch.tv/someSlug');
  assert.equal(this.$('img').attr('src'), 'tiny');
});

test('render when slug is valid but title is not', function(assert) {
  assert.expect(3);

  this.responseMock.title = '';
  clipInfoPromise = RSVP.resolve(this.responseMock);
  this.render(this.defaultTemplate);

  assert.equal(this.$('.card__title').text().trim(), 'broadcasterDisplayName streaming game');
  assert.equal(this.$('a').attr('href'), 'https://clips.twitch.tv/someSlug');
  assert.equal(this.$('img').attr('src'), 'tiny');
});

test('render when title is invalid and slug is invalid', function(assert) {
  assert.expect(3);

  clipInfoPromise = RSVP.reject();
  this.render(this.defaultTemplate);

  // Update when we add some classes
  return wait().then(() => {
    assert.equal(this.$('.card__title').text().trim(), 'Something went wrong');
    assert.equal(this.$('.card__info').text().trim(), 'We couldn\'t find that Clip.');
    assert.equal(this.$('img').attr('src'), NOTLIKETHIS_IMAGE);
  });
});

test('gracefully fails when title and slug is not provided', function(assert) {
  assert.expect(3);

  this.set('channel', null);
  this.set('slug', null);
  this.render(this.defaultTemplate);

  assert.equal(this.$('.card__title').text().trim(), 'Something went wrong');
  assert.equal(this.$('.card__info').text().trim(), 'We couldn\'t find that Clip.');
  assert.equal(this.$('img').attr('src'), NOTLIKETHIS_IMAGE);
});

test('uses "being" instead of streaming for Creative when title is not available', function(assert) {
  assert.expect(1);

  this.responseMock.game = 'Creative';
  this.responseMock.title = '';
  clipInfoPromise = RSVP.resolve(this.responseMock);
  this.render(this.defaultTemplate);

  assert.equal(this.$('.card__title').text().trim(), 'broadcasterDisplayName being Creative');
});
