import { test } from 'ember-qunit';
import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import hbs from 'htmlbars-inline-precompile';
import sinon from 'sinon';
import { TEST_SELECTOR } from 'web-client/components/clips/clips-directory-nav-hotspot/component';

moduleForComponent('clips/clips-directory-nav-hotspot', 'Integration | Component | clips-directory-nav-hotspot', {
  integration: true,
  beforeEach() {
    this.dismissSpy = sinon.spy();
    this.set('dismiss', this.dismissSpy);
    this.defaultTemplate = hbs`{{clips/clips-directory-nav-hotspot dismiss=dismiss}}`;
    this.testSelector = `[data-test-selector="${TEST_SELECTOR}"]`;
  }
});

test('on render', function(assert) {
  assert.expect(3);

  this.render(this.defaultTemplate);

  assert.elementText(
    '.balloon',
    new RegExp('Check out the best clips from this channel!'),
    'renders balloon with message'
  );
  assert.elementText(
    '.balloon a[href="http://link.twitch.tv/clips-channelpage-onsite-blogus-20170131"]',
    new RegExp('Learn More'),
    'renders Learn More with link to help article'
  );
  assert.elementText(
    '.balloon button',
    new RegExp('Dismiss'),
    'renders Dismiss button'
  );
});

test('on click', function (assert) {
  assert.expect(1);

  this.render(this.defaultTemplate);

  this.$(this.testSelector).click();

  assert.ok(this.dismissSpy.called, 'dismiss action invoked');
});
