import { moduleForComponent, test } from 'ember-qunit';
import Service from 'ember-service';
import hbs from 'htmlbars-inline-precompile';
import { clipModel } from 'web-client/mirage/fixtures/clips';
import sinon from 'sinon';
import RSVP from 'rsvp';
import config from 'web-client/config/environment';

let removeResponsePromise;

moduleForComponent('clips/clips-modal-remove', 'Integration | Component | clips-modal-remove', {
  integration: true,
  beforeEach() {
    this.set('clip', clipModel);
    this.closeRemoveModalSpy = sinon.spy();
    this.set('closeRemoveModal', this.closeRemoveModalSpy);
    this.closeModalSpy = sinon.spy();
    this.set('closeModal', this.closeModalSpy);

    removeResponsePromise = RSVP.resolve('successful');
    this.container.lookup('service:intl').setLocale(config.i18n.baseLocale);

    this.register('service:clips', Service.extend({
      removeClipRecord: () => removeResponsePromise
    }));

    this.notifySuccessSpy = sinon.spy();
    this.notifyErrorSpy = sinon.spy();
    this.register('service:notify', Service.extend({
      success: this.notifySuccessSpy,
      error: this.notifyErrorSpy
    }));

    this.defaultTemplate = hbs`{{clips/clips-modal-remove clip=clip closeRemoveModal=closeRemoveModal closeModal=closeModal}}`;

    this.clipInfoSelector = '[data-test-selector="clips-modal-remove"]';
  }
});

test('renders header and subheader', function (assert) {
  assert.expect(2);
  this.render(this.defaultTemplate);

  let headerSelector = '.content-header';
  assert.elementCount(headerSelector, 1, 'renders');

  let subheaderSelector = '.sub-text';
  assert.elementCount(subheaderSelector, 1, 'renders');
});

test('clicking Cancel button', function (assert) {
  assert.expect(1);
  this.render(this.defaultTemplate);

  let closeRemoveSelector = 'button[data-test-selector="closeRemoveModal"]';
  this.$(closeRemoveSelector).click();

  assert.ok(this.closeRemoveModalSpy.calledOnce, 'calls closeRemoveModal');
});

test('clicking Delete button and the response was successful', function (assert) {
  assert.expect(2);

  this.render(this.defaultTemplate);

  let onRemoveClipSelector = 'button[data-test-selector="onRemoveClip"]';
  this.$(onRemoveClipSelector).click();

  assert.ok(this.closeModalSpy.calledOnce, 'calls closeModal');
  assert.ok(this.notifySuccessSpy.calledOnce, 'calls notifySuccess');
});

test('clicking Delete button and the response was unsuccessful', function (assert) {
  assert.expect(2);

  removeResponsePromise = RSVP.reject('unsuccessful');

  this.render(this.defaultTemplate);

  let onRemoveClipSelector = 'button[data-test-selector="onRemoveClip"]';
  this.$(onRemoveClipSelector).click();

  assert.ok(this.closeModalSpy.calledOnce, 'calls closeModal');
  assert.ok(this.notifyErrorSpy.calledOnce, 'calls notifyError');
});
