import { moduleForComponent, test } from 'ember-qunit';
import Service from 'ember-service';
import hbs from 'htmlbars-inline-precompile';
import { clipModel } from 'web-client/mirage/fixtures/clips';
import sinon from 'sinon';
import RSVP from 'rsvp';
import config from 'web-client/config/environment';

let reportResponsePromise;

moduleForComponent('clips/clips-modal-report', 'Integration | Component | clips-modal-report', {
  integration: true,
  beforeEach() {
    this.set('clip', clipModel);
    this.closeReportModalSpy = sinon.spy();
    this.set('closeReportModal', this.closeReportModalSpy);
    this.closeModalSpy = sinon.spy();
    this.set('closeModal', this.closeModalSpy);

    reportResponsePromise = RSVP.resolve('successful');
    this.container.lookup('service:intl').setLocale(config.i18n.baseLocale);

    this.register('service:clips', Service.extend({
      reportClip: () => reportResponsePromise
    }));

    this.notifySuccessSpy = sinon.spy();
    this.notifyErrorSpy = sinon.spy();
    this.register('service:notify', Service.extend({
      success: this.notifySuccessSpy,
      error: this.notifyErrorSpy
    }));

    this.defaultTemplate = hbs`{{clips/clips-modal-report clip=clip closeReportModal=closeReportModal closeModal=closeModal}}`;

    this.clipInfoSelector = '[data-test-selector="clips-modal-report"]';
  }
});

test('renders header and subheader', function (assert) {
  assert.expect(2);
  this.render(this.defaultTemplate);

  let headerSelector = '.content-header';
  assert.elementCount(headerSelector, 1, 'renders');

  let subheaderSelector = '.sub-text';
  assert.elementCount(subheaderSelector, 1, 'renders');
});

test('clicking Cancel button', function (assert) {
  assert.expect(1);
  this.render(this.defaultTemplate);

  let closeRemoveSelector = 'button[data-test-selector="closeReportModal"]';
  this.$(closeRemoveSelector).click();

  assert.ok(this.closeReportModalSpy.calledOnce, 'calls closeReportModal');
});

test('clicking Send button and the response was successful', function (assert) {
  assert.expect(2);

  this.render(this.defaultTemplate);

  let onReportClipSelector = 'button[data-test-selector="onReportClip"]';
  this.$(onReportClipSelector).attr('disabled', false);
  this.$(onReportClipSelector).click();

  assert.ok(this.closeModalSpy.calledOnce, 'calls closeModal');
  assert.ok(this.notifySuccessSpy.calledOnce, 'calls notifySuccess');
});

test('clicking Send button should do nothing when the button is disabled', function (assert) {
  assert.expect(2);

  this.render(this.defaultTemplate);

  let onReportClipSelector = 'button[data-test-selector="onReportClip"]';
  this.$(onReportClipSelector).click();

  assert.ok(this.closeModalSpy.notCalled, 'calls closeModal');
  assert.ok(this.notifySuccessSpy.notCalled, 'calls notifySuccess');
});

test('clicking Send button and the response was unsuccessful', function (assert) {
  assert.expect(2);

  reportResponsePromise = RSVP.reject('unsuccessful');

  this.render(this.defaultTemplate);

  let onReportClipSelector = 'button[data-test-selector="onReportClip"]';
  this.$(onReportClipSelector).attr('disabled', false);
  this.$(onReportClipSelector).click();

  assert.ok(this.closeModalSpy.calledOnce, 'calls closeModal');
  assert.ok(this.notifyErrorSpy.calledOnce, 'calls notifyError');
});
