import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';
import { clipModel } from 'web-client/mirage/fixtures/clips';
import { AuthenticatedSession, userData } from 'web-client/tests/helpers/mock-session-service';
import { assign } from 'ember-platform';

import sinon from 'sinon';

moduleForComponent('clips/clips-more-button', 'Integration | Component | clips-more-button', {
  integration: true,
  beforeEach() {
    this.set('clip', clipModel);
    this.openRemoveModalSpy = sinon.spy();
    this.set('openRemoveModal', this.openRemoveModalSpy);
    this.register('service:session', AuthenticatedSession);

    this.defaultTemplate = hbs`{{clips/clips-more-button clip=clip openRemoveModal=openRemoveModal}}`;

    this.clipInfoSelector = '[data-test-selector="clips-more-button"]';
  }
});

test('when the user is not staff, curator, nor broadcaster', function (assert) {
  assert.expect(1);

  this.render(this.defaultTemplate);

  let headerSelector = '[data-test-selector="clips-more-button"]';
  assert.elementCount(headerSelector, 1, 'renders the more button for report modal');
});

test('when the user is staff', function (assert) {
  assert.expect(1);

  const staffSession = AuthenticatedSession.extend({
    userData: assign({}, userData, {is_staff: true})
  });
  this.register('service:session', staffSession);
  this.render(this.defaultTemplate);

  let headerSelector = '[data-test-selector="clips-more-button"]';
  assert.elementCount(headerSelector, 1, 'renders more button');
});

test('when the user is curator', function (assert) {
  assert.expect(1);

  const curatorSession = AuthenticatedSession.extend({
    userData: assign({}, userData, {id: clipModel.curatorID})
  });
  this.register('service:session', curatorSession);
  this.render(this.defaultTemplate);

  let headerSelector = '[data-test-selector="clips-more-button"]';
  assert.elementCount(headerSelector, 1, 'renders more button');
});

test('when the user is broadcaster', function (assert) {
  assert.expect(1);

  const broadcasterSession = AuthenticatedSession.extend({
    userData: assign({}, userData, {id: clipModel.broadcasterID})
  });
  this.register('service:session', broadcasterSession);
  this.render(this.defaultTemplate);

  let headerSelector = '[data-test-selector="clips-more-button"]';
  assert.elementCount(headerSelector, 1, 'renders more button');
});

test('when clicking the remove button', function (assert) {
  assert.expect(1);

  const broadcasterSession = AuthenticatedSession.extend({
    userData: assign({}, userData, {id: clipModel.broadcasterID})
  });
  this.register('service:session', broadcasterSession);
  this.render(this.defaultTemplate);

  let closeRemoveSelector = '.balloon__link--alert';
  this.$(closeRemoveSelector).click();

  assert.ok(this.openRemoveModalSpy.calledOnce, 'calls openRemoveModal');
});

test('when clicking the more button', function (assert) {
  assert.expect(2);

  const broadcasterSession = AuthenticatedSession.extend({
    userData: assign({}, userData, {id: clipModel.broadcasterID})
  });
  this.register('service:session', broadcasterSession);
  this.render(this.defaultTemplate);

  const removeSelector = '.balloon--dropmenu';

  assert.elementCount(`${removeSelector}.hide`, 1, 'hides before the click');

  const closeRemoveSelector = '.button--more';
  this.$(closeRemoveSelector).click();

  assert.elementCount(`${removeSelector}.show`, 1, 'show after the click');
});
