import { test } from 'ember-qunit';
import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import hbs from 'htmlbars-inline-precompile';
import { clipModel } from 'web-client/mirage/fixtures/clips';
import {
  FACEBOOK_SHARE_MEDIUM,
  TWITTER_SHARE_MEDIUM,
  REDDIT_SHARE_MEDIUM
} from 'web-client/components/clips/clips-share-box/component';
import { assign } from 'ember-platform';
import { parseQueryParams, withQueryParams } from 'web-client/utilities/url-params';
import {
  facebookShareLink,
  twitterShareLink,
  redditShareLink
} from 'web-client/utilities/social-links';

moduleForComponent('clips/clips-share-box', 'Integration | Component | clips-share-box', {
  integration: true,
  beforeEach() {
    this.set('clip', clipModel);
    this.defaultTemplate = hbs`{{clips/clips-share-box clip}}`;
    this.render(this.defaultTemplate);
  }
});

test('facebook share icon', function(assert) {
  assert.expect(2);
  assert.elementCount('.js-fb', 1, 'is rendered');

  let expectedClipURL = withQueryParams(clipModel.url, ['tt_medium'], { tt_medium: FACEBOOK_SHARE_MEDIUM });
  let expectedShareURL = facebookShareLink(expectedClipURL);

  assert.equal(this.$('a.js-fb').attr('href'), expectedShareURL, 'links to share page for Facebook');
});

test('twitter share icon', function (assert) {
  assert.expect(2);
  assert.elementCount('.js-twitter', 1, 'is rendered');

  let expectedClipURL = withQueryParams(clipModel.url, ['tt_medium'], { tt_medium: TWITTER_SHARE_MEDIUM });
  let expectedShareURL = twitterShareLink(expectedClipURL, clipModel.title);
  assert.equal(this.$('a.js-twitter').attr('href'), expectedShareURL, 'links to share page for Twitter');
});

test('reddit share icon', function (assert) {
  assert.expect(2);

  assert.elementCount('.js-reddit', 1, 'is rendered');

  let expectedClipURL = withQueryParams(clipModel.url, ['tt_medium'], { tt_medium: REDDIT_SHARE_MEDIUM });
  let expectedShareURL = redditShareLink(expectedClipURL, clipModel.title);

  assert.equal(this.$('a.js-reddit').attr('href'), expectedShareURL, 'links to share page for Reddit');
});

test('when Clip title is empty', function (assert) {
  assert.expect(2);

  let defaultMessage = `Check out this clip from ${clipModel.broadcasterDisplayName}'s stream`;
  this.set('clip', assign({}, clipModel, {title: ''}));

  let { title: redditTitleParam } = parseQueryParams(this.$('a.js-reddit').attr('href').split('?')[1]);
  let { text: twitterTextParam } = parseQueryParams(this.$('a.js-twitter').attr('href').split('?')[1]);

  assert.equal(twitterTextParam, defaultMessage, 'twitter share link has default message as text param');
  assert.equal(redditTitleParam, defaultMessage, 'reddit share link has default message as title param');
});

