import { test } from 'ember-qunit';
import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import hbs from 'htmlbars-inline-precompile';
import {
  SORT_PERIOD_DAY,
  SORT_PERIOD_WEEK,
  SORT_PERIOD_MONTH,
  SORT_PERIOD_ALL,
  SORT_TRENDING
} from 'web-client/adapters/clip';
import sinon from 'sinon';
import { TEST_SELECTOR } from 'web-client/components/clips/clips-sort-option/component';

moduleForComponent('clips/clips-sort-option', 'Integration | Component | clips-sort-option', {
  integration: true,
  beforeEach() {
    this.onClickSpy = sinon.spy();
    this.set('sortOption', SORT_TRENDING);
    this.set('isActiveSortOption', false);
    this.set('onClick', this.onClickSpy);
    this.defaultTemplate = hbs`
      {{clips/clips-sort-option sortOption
        isActiveSortOption=isActiveSortOption
        onClick=onClick
      }}
    `;
    this.testSelector = `[data-test-selector="${TEST_SELECTOR}"]`;
  }
});

test('when the sortOption is not active', function(assert) {
  assert.expect(2);

  this.render(this.defaultTemplate);

  assert.notElementHasClass(this.testSelector, 'filter-bar__balloon-link--active', 'does not have active balloon class');

  this.$(this.testSelector).click();
  assert.ok(this.onClickSpy.calledWith(this.get('sortOption')), 'calls click handler with sortOption');
});

test('when the sortOption is active', function(assert) {
  assert.expect(2);

  this.set('isActiveSortOption', true);
  this.render(this.defaultTemplate);

  assert.elementHasClass(this.testSelector, 'filter-bar__balloon-link--active', 'has active balloon class');

  this.$(this.testSelector).click();
  assert.notOk(this.onClickSpy.called, 'click handler not called');
});

test('when sortOption is "trending"', function(assert) {
  assert.expect(1);

  this.render(this.defaultTemplate);

  assert.elementText(this.testSelector, 'Trending', 'base text is "Trending"');
});

test('when sortOption is not "trending"', function(assert) {
  assert.expect(1);

  this.set('sortOption', SORT_PERIOD_DAY);
  this.render(this.defaultTemplate);

  assert.elementText(this.testSelector, /Top/, 'text contains "Top"');
});

test('pills for sort options', function(assert) {
  assert.expect(5);

  let pillSelector = '.pill';
  this.render(this.defaultTemplate);

  this.set('sortOption', SORT_TRENDING);
  assert.elementCount(pillSelector, 0, 'no pill for "trending" sort option');

  this.set('sortOption', SORT_PERIOD_ALL);
  assert.elementText(pillSelector, 'all', 'pill contains "all"');

  this.set('sortOption', SORT_PERIOD_DAY);
  assert.elementText(pillSelector, '24h', 'pill contains "24h"');

  this.set('sortOption', SORT_PERIOD_WEEK);
  assert.elementText(pillSelector, '7d', 'pill contains "7d"');

  this.set('sortOption', SORT_PERIOD_MONTH);
  assert.elementText(pillSelector, '30d', 'pill contains "30d"');
});
