import { test } from 'ember-qunit';
import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import wait from 'ember-test-helpers/wait';
import hbs from 'htmlbars-inline-precompile';
import { loadGameDetail, loadOffer } from 'web-client/tests/integration/components/directory/game-details/game-detail-helper';
import moment from 'moment';

moduleForComponent('commerce/buy-game-now', 'Integration | Component | commerce/buy-game-now', {
  beforeEach() {
    this.store = this.owner.lookup('service:store');
    this.loadGameDetail = loadGameDetail;
    this.loadOffer = loadOffer;
  }
});

const GAME_TO_BUY = {
  actionDetails: {
    destination_url: "Url to twitch.amazon.com checkout"
  },
  product: {
    title: "Game to Buy",
    // This is evaluated when the test is imported... ensure it outlives the tests
    release_end_date: moment().add(20, 'minute').toISOString(),
    price: {
      price: "19.99",
      currency_unit: "USD"
    }
  }
};

const GAME_OWNED = {
  product: {
    title: "Game to Buy",
    // This is evaluated when the test is imported... ensure it outlives the tests
    release_end_date: moment().add(20, 'minute').toISOString(),
    price: {
      price: "19.99",
      currency_unit: "USD"
    }
  },
  userEntitlement: {
    entitled: true
  }
};

test('When game is for-sale, buy now button and price shows', function(assert) {
  this.loadGameDetail(GAME_TO_BUY);
  this.set('channel', "IntegrationTest");
  this.render(hbs`{{commerce/buy-game-now
    gameDetails=gameDetail
    channel=channel
  }}`);
  return wait().then(() => {
    assert.elementText(this.$(), 'Buy Now 19.99 USD', 'Buy Now shown');
  });


});

test('When game is entitled, get launcher button shows', function(assert) {
  this.loadGameDetail(GAME_OWNED);
  this.set('channel', "IntegrationTest");
  this.render(hbs`{{commerce/buy-game-now
    gameDetails=gameDetail
    channel=channel
  }}`);
  return wait().then(() => {
    assert.elementText(this.$(), 'Download the Launcher', 'Download The Launcher shown');
  });


});
