import { test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';
import moduleForComponent from 'web-client/tests/helpers/module-for-component';

const BALLOON_SELECTOR = '[data-test-selector="balloon"]';
const PADDING = 'pd-x-2';
const DIRECTION = 'up';
const IS_DROP_MENU = 'true';
const SIZE = 'xs';

moduleForComponent('common/balloon-container', 'Integration | Component | common/balloon-container', {
  beforeEach() {
    this.set('direction', DIRECTION);
    this.set('isDropMenu', IS_DROP_MENU);
    this.set('padding', PADDING);
    this.set('size', SIZE);
    this.set('show', null);
    this.set('testSelector', 'balloon');

    this.template = hbs`
      {{common/balloon-container
        direction=direction
        isDropMenu=isDropMenu
        padding=padding
        size=size
        show=show
        testSelector=testSelector
      }}
    `;
  }
});

test('rendering the component', function(assert) {
  this.render(this.template);

  assert.elementHasClass(BALLOON_SELECTOR, PADDING, 'should have proper padding');
  assert.elementHasClass(BALLOON_SELECTOR, `balloon--${DIRECTION}`, 'should have correct direction');
  assert.elementHasClass(BALLOON_SELECTOR, 'balloon--dropmenu', 'should be a drop menu');
  assert.elementHasClass(BALLOON_SELECTOR, 'balloon--no-tail', 'should have no tail');
  assert.elementHasClass(BALLOON_SELECTOR, `balloon--${SIZE}`, 'should have correct size');

  assert.notElementHasClass(BALLOON_SELECTOR, 'show', 'should not force balloon to show');
  assert.notElementHasClass(BALLOON_SELECTOR, 'hide', 'should not force balloon to hide');
});

test('setting show to true', function(assert) {
  this.set('show', true);
  this.render(this.template);

  assert.elementHasClass(BALLOON_SELECTOR, 'show', 'should force balloon to show');
  assert.notElementHasClass(BALLOON_SELECTOR, 'hide', 'should force balloon to show');
});

test('setting show to false', function(assert) {
  this.set('show', false);
  this.render(this.template);

  assert.elementHasClass(BALLOON_SELECTOR, 'hide', 'should force balloon to hide');
  assert.notElementHasClass(BALLOON_SELECTOR, 'show', 'should not force balloon to show');
});

test('passing a CSV set of directions', function(assert) {
  this.set('direction', 'down,right');
  this.render(this.template);

  assert.elementHasClass(BALLOON_SELECTOR, `balloon--down`, 'should have correct direction');
  assert.elementHasClass(BALLOON_SELECTOR, `balloon--right`, 'should have correct direction');
});
