import { test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';
import moduleForComponent from 'web-client/tests/helpers/module-for-component';

const BUTTON_SELECTOR = '[data-test-selector="button"]';
const BALLOON_SELECTOR = '[data-test-selector="balloon"]';
const BALLOON_ITEM_SELECTOR = '[data-test-selector="balloon-item"]';
const BALLOON_SEPARATOR_SELECTOR = '[data-test-selector="balloon-item-separator"]';

moduleForComponent('common/balloon-menu', 'Integration | Component | common/balloon-menu', {
  beforeEach() {
    this.set('isDropMenu', true);
    this.template = hbs`
      {{#common/balloon-menu isDropMenu=isDropMenu as |menu|}}
        {{menu.button testSelector='button'}}
        {{#menu.balloon testSelector='balloon'}}
          {{#menu.balloonItem testSelector='balloon-item'}}1{{/menu.balloonItem}}
          {{#menu.balloonItem}}2{{/menu.balloonItem}}
          {{menu.balloonItem testSelector='balloon-item-separator' isSeparator=true}}
          {{#menu.balloonItem}}3{{/menu.balloonItem}}
        {{/menu.balloon}}
      {{/common/balloon-menu}}
    `;
  }
});

test('rendering the menu', function(assert) {
  this.render(this.template);

  assert.elementCount(BUTTON_SELECTOR, 1, 'should render the button');
  assert.elementCount(BALLOON_SELECTOR, 1, 'should render the balloon');
  assert.elementCount(BALLOON_ITEM_SELECTOR, 1, 'should render an item in the balloon');
  assert.elementCount(BALLOON_SEPARATOR_SELECTOR, 1, 'should render a separator in the balloon');

  assert.elementHasClass(BALLOON_SEPARATOR_SELECTOR, 'balloon__stroke', 'balloon item should be separator');
});

test('toggling the balloon menu', function(assert) {
  this.render(this.template);

  assert.notElementHasClass(BALLOON_SELECTOR, 'show', 'the balloon should not be shown');
  this.$(BUTTON_SELECTOR).click();
  assert.elementHasClass(BALLOON_SELECTOR, 'show', 'the balloon should be shown');
});

test('setting isDropMenu to false', function(assert) {
  this.set('isDropMenu', false);
  this.render(this.template);

  assert.notElementHasClass(BUTTON_SELECTOR, 'button--dropmenu', 'button should not be dropmenu');
  assert.notElementHasClass(BUTTON_SELECTOR, 'balloon--dropmenu', 'balloon should not be dropmenu');
});
