import { test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';
import sinon from 'sinon';
import moduleForComponent from 'web-client/tests/helpers/module-for-component';

moduleForComponent('common/button-element', 'Integration | Component | common/button-element', {
  beforeEach() {
    this.set('isDisabled', false);
    this.set('isHollow', false);
    this.set('isText', false);
    this.set('hasIcon', false);
    this.set('iconOnly', false);
    this.set('size', '');
    this.set('ariaLabel', null);
    this.set('testSelector', null);

    this.template = hbs`
      {{#common/button-element
        isDisabled=isDisabled
        isHollow=isHollow
        isText=isText
        hasIcon=hasIcon
        iconOnly=iconOnly
        size=size
        testSelector=testSelector
        ariaLabel=ariaLabel
        onClick=onClick
      }}
        Test Block
      {{/common/button-element}}
    `;

    this.render(this.template);
    this.$button = this.$('button.button');
  }
});

test('rendering the component', function(assert) {
  assert.elementCount(this.$button, 1, 'the component should be present');
  assert.ok(this.$button.hasClass('button'), 'should have button class');
  assert.elementText(this.$button, 'Test Block', 'should render the button text');
});

test('disabling the button', function(assert) {
  this.set('isDisabled', true);

  assert.ok(this.$button.hasClass('button--disabled'), 'should add the correct class');
  assert.notEqual(this.$button.attr('disabled'), undefined, 'should add the correct attr');
});

test('making the button hollow', function(assert) {
  this.set('isHollow', true);

  assert.ok(this.$button.hasClass('button--hollow'), 'should add the correct class');
});

test('setting to text mode', function(assert) {
  this.set('isText', true);

  assert.ok(this.$button.hasClass('button--text'), 'should add the correct class');
});

test('setting to icon mode', function(assert) {
  this.set('hasIcon', true);

  assert.ok(this.$button.hasClass('button--icon'), 'should add the correct class');
});

test('setting to icon only mode', function(assert) {
  this.set('iconOnly', true);

  assert.ok(this.$button.hasClass('button--icon-only'), 'should add the correct class');
});

test('adding an ariaLabel', function(assert) {
  this.set('ariaLabel', 'my button');

  assert.equal(this.$button.attr('aria-label'), 'my button', 'should add the correct attribute');
});

test('setting to large mode', function(assert) {
  this.set('size', 'large');

  assert.ok(this.$button.hasClass('button--large'), 'should add the correct class');
});

test('setting to small mode', function(assert) {
  this.set('size', 'small');

  assert.ok(this.$button.hasClass('button--small'), 'should add the correct class');
});

test('adding a testSelector', function(assert) {
  let selectorValue = 'testing';
  this.set('testSelector', selectorValue);

  assert.equal(this.$button.attr('data-test-selector'), selectorValue, 'should set the test selector value');
});

test('clicking the button', function(assert) {
  let spy = sinon.spy();
  this.set('onClick', spy);

  this.$button.click();
  assert.ok(spy.called, 'should invoke the specified callback');
});
