import { test } from 'ember-qunit';
import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import hbs from 'htmlbars-inline-precompile';
import { JTV_USER_PICTURES_404_USER_150X150_URL } from 'web-client/utilities/urls/static-cdn';

const CARD_ROW_SELECTOR = '[data-test-selector="selector"]';
const IMAGE_SRC = JTV_USER_PICTURES_404_USER_150X150_URL;
const IMAGE_ALT = 'alt text';
const TITLE = 'Card Row Body Title';
const INFO = 'Card Row Body Info';
const TEST_SELECTOR = 'selector';

moduleForComponent('common/card-row', 'Integration | Component | common/card-row', {
  beforeEach() {
    this.set('imageAlt', IMAGE_ALT);
    this.set('imageOptions', '');
    this.set('imageSrc', IMAGE_SRC);
    this.set('isSmall', false);
    this.set('title', TITLE);
    this.set('info', INFO);
    this.set('testSelector', TEST_SELECTOR);

    this.template = hbs`
      {{common/card-row
        imageAlt=imageAlt
        imageOptions=imageOptions
        imageSrc=imageSrc
        isSmall=isSmall
        title=title
        info=info
        testSelector=testSelector
      }}
    `;

    this.render(this.template);
  }
});

test('rendering the component', function(assert) {
  let $img = this.$('img');

  assert.equal($img.attr('src'), IMAGE_SRC, 'should set a card image src');
  assert.equal($img.attr('alt'), IMAGE_ALT, 'should set a card image alt');
  assert.elementText(this.$('.card__title'), TITLE, 'should render a card title');
  assert.elementText(this.$('.card__info'), INFO, 'should render card info');
  assert.equal($(CARD_ROW_SELECTOR).attr('data-test-selector'), TEST_SELECTOR, 'should set a test selector');

  assert.notElementHasClass(CARD_ROW_SELECTOR, 'card--xs', 'should not be extra small');
});

test('rendering the component in block format', function(assert) {
  let blockTemplate = hbs`
      {{#common/card-row imageSrc=imageSrc}}
        <div class='js-card-body'>Foo Bar</div>
      {{/common/card-row}}
  `;

  this.render(blockTemplate);
  assert.elementCount('.js-card-body', 1, 'should render the component block');
});

test('setting customization properties', function(assert) {
  this.set('isSmall', true);
  this.set('imageOptions', 'avatar,sidekick,vod');

  assert.elementHasClass(CARD_ROW_SELECTOR, 'card--sm', 'should have sm class');
  assert.elementHasClass('figure', 'card__img--avatar', 'should have image class options');
  assert.elementHasClass('figure', 'card__img--sidekick', 'should have image class options');
});
